/*
 * Decompiled with CFR 0.152.
 */
package com.gardenevery.tag;

import com.gardenevery.tag.Key;
import com.gardenevery.tag.TagManager;
import com.gardenevery.tag.TagType;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public final class TagHelper {
    private TagHelper() {
    }

    public static Set<String> tags(@Nullable ItemStack stack) {
        Key.ItemKey key = Key.ItemKey.toKey(stack);
        return key != null ? TagManager.ITEM.getTag(key) : Collections.emptySet();
    }

    public static Set<String> tags(@Nullable FluidStack stack) {
        Key.FluidKey key = Key.FluidKey.toKey(stack);
        return key != null ? TagManager.FLUID.getTag(key) : Collections.emptySet();
    }

    public static Set<String> tags(@Nullable Block block) {
        Key.BlockKey key = Key.BlockKey.toKey(block);
        return key != null ? TagManager.BLOCK.getTag(key) : Collections.emptySet();
    }

    public static Set<String> tags(@Nullable IBlockState blockState) {
        Key.BlockKey key = null;
        if (blockState != null) {
            key = Key.BlockKey.toKey(blockState.func_177230_c());
        }
        return key != null ? TagManager.BLOCK.getTag(key) : Collections.emptySet();
    }

    public static <T> Set<T> element(@Nullable String tagName, @Nonnull TagType type) {
        Set set;
        if (TagHelper.isTagInvalid(tagName)) {
            return Collections.emptySet();
        }
        switch (type) {
            case ITEM: {
                Set<Key.ItemKey> keys = TagManager.ITEM.getKey(tagName);
                ObjectOpenHashSet result = new ObjectOpenHashSet();
                for (Key.ItemKey key : keys) {
                    result.add(key.toElement());
                }
                set = Collections.unmodifiableSet(result);
                break;
            }
            case FLUID: {
                Set<Key.FluidKey> keys = TagManager.FLUID.getKey(tagName);
                ObjectOpenHashSet result = new ObjectOpenHashSet();
                for (Key.FluidKey key : keys) {
                    result.add(key.toElement());
                }
                set = Collections.unmodifiableSet(result);
                break;
            }
            case BLOCK: {
                Set<Key.BlockKey> keys = TagManager.BLOCK.getKey(tagName);
                ObjectOpenHashSet result = new ObjectOpenHashSet();
                for (Key.BlockKey key : keys) {
                    result.add(key.toElement());
                }
                set = Collections.unmodifiableSet(result);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return set;
    }

    public static Set<ItemStack> itemElement(@Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName)) {
            return Collections.emptySet();
        }
        Set<Key.ItemKey> keys = TagManager.ITEM.getKey(tagName);
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        for (Key.ItemKey key : keys) {
            result.add(key.toElement());
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<FluidStack> fluidElement(@Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName)) {
            return Collections.emptySet();
        }
        Set<Key.FluidKey> keys = TagManager.FLUID.getKey(tagName);
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        for (Key.FluidKey key : keys) {
            result.add(key.toElement());
        }
        return Collections.unmodifiableSet(result);
    }

    public static Set<Block> blockElement(@Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName)) {
            return Collections.emptySet();
        }
        Set<Key.BlockKey> keys = TagManager.BLOCK.getKey(tagName);
        ObjectOpenHashSet result = new ObjectOpenHashSet();
        for (Key.BlockKey key : keys) {
            result.add(key.toElement());
        }
        return Collections.unmodifiableSet(result);
    }

    public static boolean hasTag(@Nullable ItemStack stack, @Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName)) {
            return false;
        }
        Key.ItemKey key = Key.ItemKey.toKey(stack);
        return key != null && TagManager.ITEM.hasTag(key, tagName);
    }

    public static boolean hasTag(@Nullable FluidStack stack, @Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName)) {
            return false;
        }
        Key.FluidKey key = Key.FluidKey.toKey(stack);
        return key != null && TagManager.FLUID.hasTag(key, tagName);
    }

    public static boolean hasTag(@Nullable Block block, @Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName)) {
            return false;
        }
        Key.BlockKey key = Key.BlockKey.toKey(block);
        return key != null && TagManager.BLOCK.hasTag(key, tagName);
    }

    public static boolean hasTag(@Nullable IBlockState blockState, @Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName) || blockState == null) {
            return false;
        }
        Key.BlockKey key = Key.BlockKey.toKey(blockState.func_177230_c());
        return key != null && TagManager.BLOCK.hasTag(key, tagName);
    }

    public static boolean hasAnyTags(@Nullable ItemStack stack, @Nullable Set<String> tagNames) {
        if (TagHelper.areTagsInvalid(tagNames)) {
            return false;
        }
        Key.ItemKey key = Key.ItemKey.toKey(stack);
        return key != null && TagManager.ITEM.hasAnyTag(key, tagNames);
    }

    public static boolean hasAnyTags(@Nullable FluidStack stack, @Nullable Set<String> tagNames) {
        if (TagHelper.areTagsInvalid(tagNames)) {
            return false;
        }
        Key.FluidKey key = Key.FluidKey.toKey(stack);
        return key != null && TagManager.FLUID.hasAnyTag(key, tagNames);
    }

    public static boolean hasAnyTags(@Nullable Block block, @Nullable Set<String> tagNames) {
        if (TagHelper.areTagsInvalid(tagNames)) {
            return false;
        }
        Key.BlockKey key = Key.BlockKey.toKey(block);
        return key != null && TagManager.BLOCK.hasAnyTag(key, tagNames);
    }

    public static boolean hasAnyTags(@Nullable IBlockState blockState, @Nullable Set<String> tagNames) {
        if (TagHelper.areTagsInvalid(tagNames) || blockState == null) {
            return false;
        }
        Key.BlockKey key = Key.BlockKey.toKey(blockState.func_177230_c());
        return key != null && TagManager.BLOCK.hasAnyTag(key, tagNames);
    }

    public static boolean doesTagExist(@Nullable String tagName, @Nonnull TagType type) {
        boolean bl;
        if (TagHelper.isTagInvalid(tagName)) {
            return false;
        }
        switch (type) {
            case ITEM: {
                bl = TagManager.ITEM.doesTagExist(tagName);
                break;
            }
            case FLUID: {
                bl = TagManager.FLUID.doesTagExist(tagName);
                break;
            }
            case BLOCK: {
                bl = TagManager.BLOCK.doesTagExist(tagName);
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return bl;
    }

    public static boolean doesTagExist(@Nullable String tagName) {
        if (TagHelper.isTagInvalid(tagName)) {
            return false;
        }
        return TagManager.ITEM.doesTagExist(tagName) || TagManager.FLUID.doesTagExist(tagName) || TagManager.BLOCK.doesTagExist(tagName);
    }

    public static boolean contains(@Nullable ItemStack stack) {
        Key.ItemKey key = Key.ItemKey.toKey(stack);
        return key != null && TagManager.ITEM.containsKey(key);
    }

    public static boolean contains(@Nullable FluidStack stack) {
        Key.FluidKey key = Key.FluidKey.toKey(stack);
        return key != null && TagManager.FLUID.containsKey(key);
    }

    public static boolean contains(@Nullable Block block) {
        Key.BlockKey key = Key.BlockKey.toKey(block);
        return key != null && TagManager.BLOCK.containsKey(key);
    }

    public static boolean contains(@Nullable IBlockState blockState) {
        if (blockState == null) {
            return false;
        }
        Key.BlockKey key = Key.BlockKey.toKey(blockState.func_177230_c());
        return key != null && TagManager.BLOCK.containsKey(key);
    }

    public static int tagCount(@Nonnull TagType type) {
        int n;
        switch (type) {
            case ITEM: {
                n = TagManager.ITEM.getTagCount();
                break;
            }
            case FLUID: {
                n = TagManager.FLUID.getTagCount();
                break;
            }
            case BLOCK: {
                n = TagManager.BLOCK.getTagCount();
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return n;
    }

    public static int tagCount() {
        return TagManager.ITEM.getTagCount() + TagManager.FLUID.getTagCount() + TagManager.BLOCK.getTagCount();
    }

    public static int totalAssociations(@Nonnull TagType type) {
        int n;
        switch (type) {
            case ITEM: {
                n = TagManager.ITEM.getAssociations();
                break;
            }
            case FLUID: {
                n = TagManager.FLUID.getAssociations();
                break;
            }
            case BLOCK: {
                n = TagManager.BLOCK.getAssociations();
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return n;
    }

    public static int associations() {
        return TagManager.ITEM.getAssociations() + TagManager.FLUID.getAssociations() + TagManager.BLOCK.getAssociations();
    }

    public static int uniqueKeyCount(@Nonnull TagType type) {
        int n;
        switch (type) {
            case ITEM: {
                n = TagManager.ITEM.getKeyCount();
                break;
            }
            case FLUID: {
                n = TagManager.FLUID.getKeyCount();
                break;
            }
            case BLOCK: {
                n = TagManager.BLOCK.getKeyCount();
                break;
            }
            default: {
                throw new IncompatibleClassChangeError();
            }
        }
        return n;
    }

    public static int keyCount() {
        return TagManager.ITEM.getKeyCount() + TagManager.FLUID.getKeyCount() + TagManager.BLOCK.getKeyCount();
    }

    private static boolean isTagInvalid(@Nullable String tagName) {
        return tagName == null || tagName.isEmpty();
    }

    private static boolean areTagsInvalid(@Nullable Set<String> tagNames) {
        return tagNames == null || tagNames.isEmpty();
    }

    private static boolean areTagsInvalid(@Nullable String[] tagNames) {
        return tagNames == null || tagNames.length == 0;
    }
}

