/*
 * Decompiled with CFR 0.152.
 */
package com.timoshamoscow.chestsearch.gui;

import com.timoshamoscow.chestsearch.ClientEvents;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;

public class SearchGui
extends Screen {
    private EditBox searchField;
    private List<Button> itemButtons = new ArrayList<Button>();
    private static final int CHEST_RANGE = 16;

    public SearchGui() {
        super((Component)Component.m_237113_((String)"\u041f\u043e\u0438\u0441\u043a \u043f\u0440\u0435\u0434\u043c\u0435\u0442\u043e\u0432 \u0432 \u0441\u0443\u043d\u0434\u0443\u043a\u0430\u0445"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchField = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 40, 200, 20, (Component)Component.m_237113_((String)"\u041f\u043e\u0438\u0441\u043a..."));
        this.searchField.m_94151_(this::onSearchTextChanged);
        this.m_142416_((GuiEventListener)this.searchField);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"\u0417\u0430\u043a\u0440\u044b\u0442\u044c"), button -> this.m_7379_()).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 40).m_253046_(200, 20).m_253136_());
        this.updateItemList("");
    }

    private void onSearchTextChanged(String searchText) {
        this.updateItemList(searchText.toLowerCase());
    }

    private void updateItemList(String filter) {
        for (Button button2 : this.itemButtons) {
            this.m_169411_((GuiEventListener)button2);
        }
        this.itemButtons.clear();
        Set<String> foundItems = this.findItemsInChests(filter);
        int y = 70;
        for (String itemName : foundItems) {
            Button itemButton = Button.m_253074_((Component)Component.m_237113_((String)itemName), button -> this.highlightChestsWithItem(itemName)).m_252794_(50, y).m_253046_(this.f_96543_ - 100, 20).m_253136_();
            this.m_142416_((GuiEventListener)itemButton);
            this.itemButtons.add(itemButton);
            if ((y += 25) <= this.f_96544_ - 60) continue;
            break;
        }
    }

    private Set<String> findItemsInChests(String filter) {
        HashSet<String> result = new HashSet<String>();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return result;
        }
        BlockPos playerPos = mc.f_91074_.m_20183_();
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    BlockEntity blockEntity = mc.f_91073_.m_7702_(checkPos);
                    if (!(blockEntity instanceof ChestBlockEntity)) continue;
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    for (int i = 0; i < chest.m_6643_(); ++i) {
                        ItemStack stack = chest.m_8020_(i);
                        if (stack.m_41619_()) continue;
                        String itemName = stack.m_41786_().getString();
                        if (!filter.isEmpty() && !itemName.toLowerCase().contains(filter)) continue;
                        result.add(itemName);
                    }
                }
            }
        }
        return result;
    }

    private void highlightChestsWithItem(String itemName) {
        ClientEvents.highlightedChests.clear();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        BlockPos playerPos = mc.f_91074_.m_20183_();
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                block2: for (int z = -16; z <= 16; ++z) {
                    BlockPos checkPos = playerPos.m_7918_(x, y, z);
                    BlockEntity blockEntity = mc.f_91073_.m_7702_(checkPos);
                    if (!(blockEntity instanceof ChestBlockEntity)) continue;
                    ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
                    for (int i = 0; i < chest.m_6643_(); ++i) {
                        ItemStack stack = chest.m_8020_(i);
                        if (stack.m_41619_() || !stack.m_41786_().getString().equals(itemName)) continue;
                        ClientEvents.highlightedChests.add(checkPos);
                        continue block2;
                    }
                }
            }
        }
        this.m_7379_();
    }

    public void m_7379_() {
        super.m_7379_();
    }
}

