/*
 * Decompiled with CFR 0.152.
 */
package lancet_.paxiplus.mixin;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import com.yungnickyoung.minecraft.paxi.PaxiPackSource;
import com.yungnickyoung.minecraft.paxi.PaxiRepositorySource;
import com.yungnickyoung.minecraft.paxi.client.ClientMixinUtil;
import com.yungnickyoung.minecraft.paxi.util.IPaxiSourceProvider;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lancet_.paxiplus.PaxiPlus;
import lancet_.paxiplus.interfaces.PackRepositoryTricks;
import lancet_.paxiplus.interfaces.PaxiRepositorySourceTricks;
import net.fabricmc.fabric.impl.resource.loader.ModResourcePackCreator;
import net.minecraft.class_3283;
import net.minecraft.class_3285;
import net.minecraft.class_3286;
import net.minecraft.class_3288;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3283.class}, priority=2000)
public abstract class PackRepositoryMixin
implements PackRepositoryTricks {
    @Final
    @Shadow
    private Set<class_3285> field_14227;
    @Unique
    private Map<String, class_3288> loadingPacksMap = Map.of();

    @Override
    @Unique
    public Optional<class_3285> getPaxiRepositorySource() {
        boolean isClient = this.field_14227.stream().noneMatch(source -> source instanceof class_3286);
        Optional<PaxiRepositorySource> paxiRepositorySource = Optional.empty();
        if (!isClient) {
            Optional<ModResourcePackCreator> moddedPackRepositorySource = this.field_14227.stream().filter(provider -> provider instanceof ModResourcePackCreator).findFirst().map(repositorySource -> (ModResourcePackCreator)repositorySource);
            if (moddedPackRepositorySource.isPresent()) {
                paxiRepositorySource = Optional.of(((IPaxiSourceProvider)moddedPackRepositorySource.get()).getPaxiSource());
            } else {
                PaxiPlus.LOGGER.error("Can't find a Paxi repository for datapacks when loading Paxi");
            }
        }
        if (paxiRepositorySource.isEmpty() && isClient && (paxiRepositorySource = ClientMixinUtil.getClientRepositorySource(this.field_14227)).isEmpty()) {
            PaxiPlus.LOGGER.error("Can't find a Paxi repository for resourcepacks when loading Paxi");
        }
        return paxiRepositorySource;
    }

    @WrapMethod(method={"discoverAvailable"})
    private Map<String, class_3288> paxiPlus$deleteDuplicatePacks(Operation<Map<String, class_3288>> original) {
        this.loadingPacksMap = Map.of();
        Map map = (Map)original.call(new Object[0]);
        Optional<class_3285> repositorySource = this.getPaxiRepositorySource();
        if (repositorySource.isEmpty()) {
            PaxiPlus.LOGGER.info("Repository could not be found when deleting duplicate Paxi packs");
        } else {
            PaxiRepositorySource paxiRepositorySource = (PaxiRepositorySource)repositorySource.get();
            List<String> orderedPacks = ((PaxiRepositorySourceTricks)paxiRepositorySource).orderedPacks();
            LinkedHashMap availablePacks = new LinkedHashMap(Map.copyOf(map));
            HashSet<String> keysToRemove = new HashSet<String>();
            block0: for (String vanillaPackId : availablePacks.keySet()) {
                for (String paxiPackId : orderedPacks) {
                    String strippedPaxiPackId = paxiPackId.replaceFirst("paxi/", "");
                    if (!vanillaPackId.equals("file/" + strippedPaxiPackId) && (!vanillaPackId.equals(strippedPaxiPackId) || ((class_3288)availablePacks.get(vanillaPackId)).method_29483().equals((Object)PaxiPackSource.PACK_SOURCE_PAXI))) continue;
                    keysToRemove.add(vanillaPackId);
                    continue block0;
                }
            }
            keysToRemove.forEach(availablePacks::remove);
            map = Map.copyOf(availablePacks);
            LinkedHashMap<String, class_3288> newMap = new LinkedHashMap<String, class_3288>(Map.of());
            int orderedPacksOccusations = 0;
            for (String packName : map.keySet()) {
                if (orderedPacks.stream().anyMatch(string -> string.equals("paxi/" + packName))) {
                    String newPack = orderedPacks.get(orderedPacksOccusations);
                    newMap.put(newPack, (class_3288)map.get(newPack));
                    ++orderedPacksOccusations;
                    continue;
                }
                newMap.put(packName, (class_3288)map.get(packName));
            }
            map = newMap;
        }
        return map;
    }

    @Inject(method={"discoverAvailable"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/packs/repository/RepositorySource;loadPacks(Ljava/util/function/Consumer;)V", shift=At.Shift.AFTER)})
    private void pullOutPacksInDiscoveringProcess(CallbackInfoReturnable<Map<String, class_3288>> cir, @Local LocalRef<Map<String, class_3288>> map, @Local class_3285 repositorySource) {
        this.loadingPacksMap = (Map)map.get();
        PaxiPlus.LOGGER.info("Loaded new packs: {}", (Object)String.join((CharSequence)", ", this.loadingPacksMap.keySet()));
        if (this.field_14227.stream().toList().indexOf(repositorySource) == this.field_14227.size() - 1) {
            Optional<class_3285> repoSource = this.getPaxiRepositorySource();
            if (repoSource.isEmpty()) {
                PaxiPlus.LOGGER.info("Repository could not be found when loading Paxi packs at last");
            } else {
                PaxiRepositorySource paxiRepoSource = (PaxiRepositorySource)repoSource.get();
                ((PaxiRepositorySourceTricks)paxiRepoSource).loadPacksTrick(pack -> ((Map)map.get()).put(pack.method_14463(), pack), (class_3283)this);
                map.set((Object)((Map)map.get()));
            }
        }
    }

    @Override
    public Map<String, class_3288> getAlreadyAvailablePacks() {
        return this.loadingPacksMap;
    }
}

