/*
 * Decompiled with CFR 0.152.
 */
package lancet_.paxiplus.mixin;

import com.google.common.collect.Lists;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.yungnickyoung.minecraft.paxi.PaxiCommon;
import com.yungnickyoung.minecraft.paxi.PaxiPackSource;
import com.yungnickyoung.minecraft.paxi.PaxiRepositorySource;
import com.yungnickyoung.minecraft.paxi.mixin.accessor.FolderRepositorySourceAccessor;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lancet_.paxiplus.PaxiPlus;
import lancet_.paxiplus.interfaces.PackRepositoryTricks;
import lancet_.paxiplus.interfaces.PaxiRepositorySourceTricks;
import lancet_.paxiplus.mixin.accessor.FilePackResourcesAccessor;
import lancet_.paxiplus.mixin.accessor.PackAccessor;
import lancet_.paxiplus.util.PaxiPlusOrdering;
import net.minecraft.class_2561;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3283;
import net.minecraft.class_3288;
import net.minecraft.class_5250;
import net.minecraft.class_5352;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={PaxiRepositorySource.class}, remap=false)
public abstract class PaxiMixin
extends class_3279
implements PaxiRepositorySourceTricks {
    @Shadow
    @Final
    private static FileFilter PACK_FILTER;
    @Shadow
    public List<String> orderedPaxiPacks;
    @Shadow
    public List<String> unorderedPaxiPacks;
    @Shadow
    private File ordering;
    @Unique
    private List<String> orderedPacks = new ArrayList<String>();
    @Unique
    private List<class_3288> builtinPacks = new ArrayList<class_3288>();
    @Unique
    private class_3283 packRepository;

    public PaxiMixin(Path path, class_3264 packType, class_5352 packSource) {
        super(path, packType, packSource);
    }

    @Unique
    private static List<Path> toPaths(List<File> files) {
        return files.stream().map(File::toPath).toList();
    }

    @Shadow
    protected abstract class_3288.class_7680 createPackResourcesSupplier(Path var1);

    @Shadow
    protected abstract List<File> filesFromNames(String[] var1, FileFilter var2);

    @Override
    public List<String> orderedPacks() {
        return this.orderedPacks;
    }

    @Override
    public void loadPacksTrick(Consumer<class_3288> packAdder, class_3283 packRepository) {
        this.packRepository = packRepository;
        this.method_14453(packAdder);
        this.packRepository = null;
    }

    public void method_14453(Consumer<class_3288> packAdder) {
        if (this.packRepository == null) {
            return;
        }
        File folder = ((FolderRepositorySourceAccessor)this).getFolder().toFile();
        if (!folder.isDirectory() && !folder.mkdirs()) {
            PaxiPlus.LOGGER.info("Couldn't create a folder for packs");
        }
        if (this.ordering != null && !this.ordering.isFile()) {
            PaxiPlusOrdering emptyPackOrdering = new PaxiPlusOrdering(new String[0]);
            try {
                JSON.createJsonFileFromObject((Path)this.ordering.toPath(), (Object)emptyPackOrdering);
            }
            catch (IOException e) {
                PaxiCommon.LOGGER.error("Unable to create default pack ordering file! This shouldn't happen.");
                PaxiCommon.LOGGER.error(e.toString());
            }
        }
        List<Path> packPathsToLoad = PaxiMixin.toPaths(this.loadPacksFromFiles());
        for (String packId : this.orderedPacks) {
            class_3288 pack = null;
            String strippedPackId = packId.replaceFirst("paxi/", "");
            if (packPathsToLoad.stream().anyMatch(path -> path.toString().contains(strippedPackId))) {
                Map<String, class_3288> map;
                Path packPath = packPathsToLoad.stream().filter(path -> path.toString().contains(strippedPackId)).findFirst().orElse(null);
                if (packPath == null) {
                    PaxiPlus.LOGGER.info("Couldn't load pack with id from file paths: {}", (Object)packId);
                    continue;
                }
                String packName = packPath.getFileName().toString();
                class_5250 packTitle = class_2561.method_43470((String)packName);
                class_3283 packRepository = this.packRepository;
                class_3264 packType = ((FolderRepositorySourceAccessor)this).getPackType();
                if (packType.equals((Object)class_3264.field_14188) && (map = ((PackRepositoryTricks)packRepository).getAlreadyAvailablePacks()).values().stream().anyMatch(mapPack -> {
                    try (class_3262 packResources = ((PackAccessor)mapPack).paxi_plus$resources().open(mapPack.method_14463());){
                        class_3258 filePackResources;
                        if (packResources instanceof class_3258 && ((FilePackResourcesAccessor)(filePackResources = (class_3258)packResources)).file().getName().equals(packName)) {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    return false;
                })) {
                    packTitle = map.get("file/" + strippedPackId).method_14457();
                }
                pack = class_3288.method_45275((String)("paxi/" + packName), (class_2561)packTitle, (boolean)true, (class_3288.class_7680)this.createPackResourcesSupplier(packPath), (class_3264)((FolderRepositorySourceAccessor)this).getPackType(), (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)PaxiPackSource.PACK_SOURCE_PAXI);
            } else if (this.builtinPacks.stream().anyMatch(builtInPack -> builtInPack.method_14463().equals(strippedPackId))) {
                class_3288 builtinPack = this.builtinPacks.stream().filter(builtPack -> builtPack.method_14463().equals(strippedPackId)).findFirst().orElse(null);
                if (builtinPack == null) {
                    PaxiPlus.LOGGER.info("Couldn't load pack with id from built-in packs: {}", (Object)packId);
                    continue;
                }
                pack = class_3288.method_45275((String)("paxi/" + builtinPack.method_14463()), (class_2561)builtinPack.method_14457(), (boolean)true, (class_3288.class_7680)((PackAccessor)builtinPack).paxi_plus$resources(), (class_3264)((FolderRepositorySourceAccessor)this).getPackType(), (class_3288.class_3289)class_3288.class_3289.field_14280, (class_5352)PaxiPackSource.PACK_SOURCE_PAXI);
            }
            if (pack == null) continue;
            packAdder.accept(pack);
        }
    }

    @Unique
    private List<File> loadPacksFromFiles() {
        this.orderedPaxiPacks.clear();
        this.unorderedPaxiPacks.clear();
        this.orderedPacks.clear();
        this.builtinPacks.clear();
        if (this.ordering != null) {
            PaxiPlusOrdering packOrdering = null;
            try {
                packOrdering = (PaxiPlusOrdering)JSON.loadObjectFromJsonFile((Path)this.ordering.toPath(), PaxiPlusOrdering.class);
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                PaxiCommon.LOGGER.error("Error loading Paxi ordering JSON file {}: {}", (Object)this.ordering.getName(), (Object)e.toString());
            }
            if (packOrdering == null) {
                PaxiCommon.LOGGER.error("Unable to load ordering JSON file {}! Is it proper JSON formatting? Ignoring load order...", (Object)this.ordering.getName());
                return List.of();
            }
            if (packOrdering.orderedPackNames() == null) {
                PaxiCommon.LOGGER.error("Unable to find entry with name 'loadOrder' in load ordering JSON file {}! Ignoring load order...", (Object)this.ordering.getName());
                return List.of();
            }
            this.builtinPacks = this.paxiPlus$findBuiltinPacks(packOrdering.orderedPackNames());
            List<File> orderedPacks = this.filesFromNames(packOrdering.orderedPackNames(), PACK_FILTER);
            File[] allPacks = ((FolderRepositorySourceAccessor)this).getFolder().toFile().listFiles(PACK_FILTER);
            ArrayList unorderedPacks = allPacks == null ? Lists.newArrayList() : Arrays.stream(allPacks).filter(file -> !orderedPacks.contains(file)).toList();
            orderedPacks.forEach(file -> this.orderedPacks.add(file.getName()));
            this.builtinPacks.forEach(pack -> this.orderedPacks.add(pack.method_14463()));
            ArrayList<String> orderedList = new ArrayList<String>(Arrays.stream(packOrdering.orderedPackNames()).toList());
            orderedList.removeIf(string -> !this.orderedPacks.contains(string) && orderedPacks.stream().noneMatch(file -> string.endsWith(file.getName())));
            ArrayList<String> finalOrderList = new ArrayList<String>();
            for (String packName : orderedList) {
                Optional<String> foundPackName = this.orderedPacks.stream().filter(string -> string.equals(packName) || packName.endsWith((String)string)).findFirst();
                if (foundPackName.isEmpty()) continue;
                finalOrderList.add(foundPackName.get());
            }
            this.orderedPacks = finalOrderList;
            finalOrderList.replaceAll(string -> "paxi/" + string);
            this.orderedPaxiPacks.addAll(finalOrderList);
            unorderedPacks.forEach(file -> this.unorderedPaxiPacks.add(file.getName()));
            return Stream.of(orderedPacks).flatMap(Collection::stream).toList();
        }
        return List.of();
    }

    @WrapMethod(method={"filesFromNames"})
    private List<File> paxiPlus$filesFromNames(String[] packFileNames, FileFilter filter, Operation<List<File>> original) {
        ArrayList<File> packFiles = new ArrayList<File>();
        for (String fileName : packFileNames) {
            if (this.builtinPacks.stream().anyMatch(pack -> pack.method_14463().equals(fileName))) continue;
            File packFile = new File(PaxiPlus.BASE_GAME_DIRECTORY, fileName);
            if (!packFile.exists()) {
                packFile = new File(((FolderRepositorySourceAccessor)this).getFolder().toFile().toString(), fileName);
            }
            if (!packFile.exists()) {
                PaxiCommon.LOGGER.error("Unable to find pack with name {} specified in load ordering JSON file {}! Skipping...", (Object)fileName, (Object)this.ordering.getName());
                continue;
            }
            if (filter != null && !filter.accept(packFile)) {
                PaxiCommon.LOGGER.error("Attempted to load pack {} but it is not a valid pack format! It may be missing a pack.mcmeta file. Skipping...", (Object)fileName);
                continue;
            }
            packFiles.add(packFile);
        }
        return packFiles;
    }

    @Unique
    private List<class_3288> paxiPlus$findBuiltinPacks(String[] packFileNames) {
        ArrayList<class_3288> builtinPacks = new ArrayList<class_3288>();
        Map<String, class_3288> map = ((PackRepositoryTricks)this.packRepository).getAlreadyAvailablePacks();
        for (String fileName : packFileNames) {
            File packFile = new File(PaxiPlus.BASE_GAME_DIRECTORY, fileName);
            if (packFile.exists()) continue;
            if (map.containsKey(fileName)) {
                class_3288 pack = map.get(fileName);
                builtinPacks.add(pack);
                continue;
            }
            PaxiPlus.LOGGER.error("Pack {} is not available at the time of loading Paxi, can't find in a map: {}.", (Object)fileName, (Object)String.join((CharSequence)", ", map.keySet()));
        }
        return builtinPacks;
    }
}

