package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

import javax.annotation.Nullable;
import java.util.Optional;

/**
 * 生物被枪械子弹击杀时触发的事件
 */
public class EntityKillByGunEvent extends BaseEvent implements KubeJSGunEventPoster<EntityKillByGunEvent> {
    private final class_1297 bullet;
    private final @Nullable class_1309 killedEntity;
    private final @Nullable class_1309 attacker;
    private final class_2960 gunId;
    private final class_2960 gunDisplayId;
    private final float baseDamage;
    private final class_1282 nonApPartDamageSource;
    private final class_1282 apPartDamageSource;
    private final boolean isHeadShot;
    private final float headshotMultiplier;
    private final LogicalSide logicalSide;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(EntityKillByGunEvent event);
    }

    public EntityKillByGunEvent(class_1297 bullet, @Nullable class_1309 hurtEntity, @Nullable class_1309 attacker,
                                class_2960 gunId, class_2960 gunDisplayId, float baseDamage, @Nullable Pair<class_1282, class_1282> sources,
                                boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
        this.bullet = bullet;
        this.killedEntity = hurtEntity;
        this.attacker = attacker;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
        this.baseDamage = baseDamage;
        this.nonApPartDamageSource = Optional.ofNullable(sources).map(Pair::getLeft).orElse(null);
        this.apPartDamageSource = Optional.ofNullable(sources).map(Pair::getRight).orElse(null);
        this.isHeadShot = isHeadShot;
        this.headshotMultiplier = headshotMultiplier;
        this.logicalSide = logicalSide;
        postEventToKubeJS(this);
    }

    /**
     * 在逻辑客户端不保证能用
     */
    public class_1297 getBullet() {
        return bullet;
    }

    @Nullable
    public class_1309 getKilledEntity() {
        return killedEntity;
    }

    @Nullable
    public class_1309 getAttacker() {
        return attacker;
    }

    public class_2960 getGunId() {
        return gunId;
    }

    public float getBaseDamage() {
        return baseDamage;
    }

    public class_1282 getDamageSource(GunDamageSourcePart part) {
        if (logicalSide.isClient()) {
            throw new UnsupportedOperationException("DamageSource about gun hit is not available on client side!");
        }
        return part == GunDamageSourcePart.ARMOR_PIERCING ? apPartDamageSource : nonApPartDamageSource;
    }

    public boolean isHeadShot() {
        return isHeadShot;
    }

    public float getHeadshotMultiplier() {
        return headshotMultiplier;
    }

    public LogicalSide getLogicalSide() {
        return logicalSide;
    }

    public class_2960 getGunDisplayId() {
        return gunDisplayId;
    }
}