package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public interface AmmoBoxItemDataAccessor extends IAmmoBox {
    String AMMO_ID_TAG = "AmmoId";
    String AMMO_COUNT_TAG = "AmmoCount";
    String CREATIVE_TAG = "Creative";
    String ALL_TYPE_CREATIVE_TAG = "AllTypeCreative";
    String LEVEL_TAG = "Level";

    @Override
    default class_2960 getAmmoId(class_1799 ammoBox) {
        class_2487 tag = ammoBox.method_7948();
        if (tag.method_10573(AMMO_ID_TAG, class_2520.field_33258)) {
            return new class_2960(tag.method_10558(AMMO_ID_TAG));
        }
        return DefaultAssets.EMPTY_AMMO_ID;
    }

    @Override
    default void setAmmoId(class_1799 ammoBox, class_2960 ammoId) {
        class_2487 tag = ammoBox.method_7948();
        tag.method_10582(AMMO_ID_TAG, ammoId.toString());
    }

    @Override
    default int getAmmoCount(class_1799 ammoBox) {
        class_2487 tag = ammoBox.method_7948();
        if (isAllTypeCreative(ammoBox) || isCreative(ammoBox)) {
            return Integer.MAX_VALUE;
        }
        if (tag.method_10573(AMMO_COUNT_TAG, class_2520.field_33253)) {
            return tag.method_10550(AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default void setAmmoCount(class_1799 ammoBox, int count) {
        class_2487 tag = ammoBox.method_7948();
        if (isCreative(ammoBox)) {
            tag.method_10569(AMMO_COUNT_TAG, Integer.MAX_VALUE);
            return;
        }
        tag.method_10569(AMMO_COUNT_TAG, count);
    }

    @Override
    default boolean isAmmoBoxOfGun(class_1799 gun, class_1799 ammoBox) {
        if (gun.method_7909() instanceof IGun iGun && ammoBox.method_7909() instanceof IAmmoBox iAmmoBox) {
            if (isAllTypeCreative(ammoBox)) {
                return true;
            }
            class_2960 ammoId = iAmmoBox.getAmmoId(ammoBox);
            if (ammoId.equals(DefaultAssets.EMPTY_AMMO_ID)) {
                return false;
            }
            class_2960 gunId = iGun.getGunId(gun);
            return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals(ammoId)).orElse(false);
        }
        return false;
    }

    @Override
    default class_1799 setAmmoLevel(class_1799 ammoBox, int level) {
        class_2487 tag = ammoBox.method_7948();
        tag.method_10569(LEVEL_TAG, Math.max(level, 0));
        return ammoBox;
    }

    @Override
    default int getAmmoLevel(class_1799 ammoBox) {
        class_2487 tag = ammoBox.method_7948();
        if (tag.method_10573(LEVEL_TAG, class_2520.field_33253)) {
            return tag.method_10550(LEVEL_TAG);
        }
        return 0;
    }

    @Override
    default boolean isCreative(class_1799 ammoBox) {
        class_2487 tag = ammoBox.method_7969();
        if (tag != null && tag.method_10573(CREATIVE_TAG, class_2520.field_33251)) {
            return tag.method_10577(CREATIVE_TAG);
        }
        return false;
    }

    @Override
    default boolean isAllTypeCreative(class_1799 ammoBox) {
        class_2487 tag = ammoBox.method_7969();
        if (tag != null && tag.method_10573(ALL_TYPE_CREATIVE_TAG, class_2520.field_33251)) {
            return tag.method_10577(ALL_TYPE_CREATIVE_TAG);
        }
        return false;
    }

    @Override
    default class_1799 setCreative(class_1799 ammoBox, boolean isAllType) {
        class_2487 tag = ammoBox.method_7948();
        if (isAllType) {
            // 移除可能存在的创造模式标签
            if (tag.method_10573(CREATIVE_TAG, class_2520.field_33251)) {
                tag.method_10551(CREATIVE_TAG);
            }
            tag.method_10556(ALL_TYPE_CREATIVE_TAG, true);
            return ammoBox;
        }
        // 移除可能存在的全类型标签
        if (tag.method_10573(ALL_TYPE_CREATIVE_TAG, class_2520.field_33251)) {
            tag.method_10551(ALL_TYPE_CREATIVE_TAG);
        }
        tag.method_10556(CREATIVE_TAG, true);
        return ammoBox;
    }
}
