package com.tacz.guns.client.input;

import cn.sh1rocu.tacz.api.event.InputEvent;
import cn.sh1rocu.tacz.api.event.PlayerTickEvent;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.client.KeyConfig;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import org.lwjgl.glfw.GLFW;

import static com.tacz.guns.util.InputExtraCheck.isInGame;

@Environment(EnvType.CLIENT)
public class ReloadKey {
    public static final class_304 RELOAD_KEY = new class_304("key.tacz.reload.desc",
            class_3675.class_307.field_1668,
            GLFW.GLFW_KEY_R,
            "key.category.tacz");

    public static void onReloadPress(InputEvent.Key event) {
        if (isInGame() && event.getAction() == GLFW.GLFW_PRESS && RELOAD_KEY.method_1417(event.getKey(), event.getScanCode())) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null || player.method_7325()) {
                return;
            }
            if (player.method_6047().method_7909() instanceof IGun iGun) {
                // 如果使用背包直读，且没有换弹冷却机制，则在输入时就屏蔽换弹
                if (iGun.useInventoryAmmo(player.method_6047())) {
                    return;
                }
                IClientPlayerGunOperator.fromLocalPlayer(player).reload();
            }
        }
    }

    public static boolean onReloadControllerPress(boolean isPress) {
        if (isInGame() && isPress) {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null || player.method_7325()) {
                return false;
            }
            if (IGun.mainHandHoldGun(player)) {
                IClientPlayerGunOperator.fromLocalPlayer(player).reload();
                return true;
            }
        }
        return false;
    }

    @Environment(EnvType.CLIENT)
    public static void autoReload(PlayerTickEvent.Pre event) {
        if (!event.getEntity().method_37908().field_9236)
            return;

        if (!KeyConfig.AUTO_RELOAD.get()) {
            return;
        }

        class_746 player = class_310.method_1551().field_1724;
        if (player == null || player.method_7325() || player.field_6012 % 5 != 0) {
            return;
        }
        class_1799 currentGunItem = player.method_6047();
        if (player.method_6047().method_7909() instanceof IGun iGun) {
            // 如果使用背包直读，且没有换弹冷却机制，则在输入时就屏蔽换弹
            if (iGun.useInventoryAmmo(player.method_6047())) {
                return;
            }
            boolean flag = TimelessAPI.getCommonGunIndex(iGun.getGunId(currentGunItem))
                    .map(gunIndex -> gunIndex.getGunData().getBolt() != Bolt.OPEN_BOLT)
                    .orElse(false);

            int ammoCount = iGun.getCurrentAmmoCount(currentGunItem) + (iGun.hasBulletInBarrel(currentGunItem) && flag ? 1 : 0);
            if (ammoCount > 0) {
                return;
            }
            IClientPlayerGunOperator.fromLocalPlayer(player).reload();
        }
    }
}
