package com.tacz.guns.client.renderer.block;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IBlock;
import com.tacz.guns.block.AbstractGunSmithTableBlock;
import com.tacz.guns.block.entity.GunSmithTableBlockEntity;
import com.tacz.guns.client.model.bedrock.BedrockModel;
import com.tacz.guns.client.resource.index.ClientBlockIndex;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

public class GunSmithTableRenderer implements class_827<GunSmithTableBlockEntity> {
    public GunSmithTableRenderer(class_5614.class_5615 context) {
    }

    public Optional<ClientBlockIndex> getIndex(GunSmithTableBlockEntity blockEntity) {
        class_2960 id = blockEntity.getId();
        if (id==null || id.equals(DefaultAssets.EMPTY_BLOCK_ID)) {
            return Optional.empty();
        }
        return TimelessAPI.getClientBlockIndex(id);
    }

    public static Optional<ClientBlockIndex> getIndex(class_1799 stack) {
        if (stack.method_7909() instanceof IBlock iBlock) {
            class_2960 id = iBlock.getBlockId(stack);
            if (id.equals(DefaultAssets.EMPTY_BLOCK_ID)) {
                return Optional.empty();
            }
            return TimelessAPI.getClientBlockIndex(id);
        }
        return Optional.empty();
    }

    @Override
    public void render(GunSmithTableBlockEntity blockEntity, float partialTick, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        getIndex(blockEntity).ifPresent(index -> {
            BedrockModel model = index.getModel();
            class_2960 texture = index.getTexture();
            if (model == null) {
                return;
            }
            class_2680 blockState = blockEntity.method_11010();
            if (blockState.method_26204() instanceof AbstractGunSmithTableBlock block) {
                if (!block.isRoot(blockState)) {
                    return;
                }
                class_2350 facing = blockState.method_11654(AbstractGunSmithTableBlock.FACING);
                poseStack.method_22903();
                poseStack.method_22904(0.5, 1.5, 0.5);
                poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
                poseStack.method_22907(class_7833.field_40715.rotationDegrees(block.parseRotation(facing)));
                class_1921 renderType = class_1921.method_23580(texture);
                model.render(poseStack, class_811.field_4315, renderType, combinedLightIn, combinedOverlayIn);
                poseStack.method_22909();
            }
        });
    }

    @Override
    public boolean shouldRenderOffScreen(GunSmithTableBlockEntity blockEntity) {
        return true;
    }
}