package com.tacz.guns.client.tooltip;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.inventory.tooltip.AttachmentItemTooltip;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5684;

public class ClientAttachmentItemTooltip implements class_5684 {
    private static final Cache<class_2960, List<class_1799>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5, TimeUnit.SECONDS).build();
    private final class_2960 attachmentId;
    private final List<class_2561> components = Lists.newArrayList();
    private final class_5250 tips = class_2561.method_43471("tooltip.tacz.attachment.yaw.shift");
    private final class_5250 support = class_2561.method_43471("tooltip.tacz.attachment.yaw.support");
    private @Nullable class_5250 packInfo;
    private List<class_1799> showGuns = Lists.newArrayList();
    private class_1799 attachment;

    public ClientAttachmentItemTooltip(AttachmentItemTooltip tooltip) {
        this.attachmentId = tooltip.getAttachmentId();
        this.attachment = tooltip.getAttachmentItem();
        this.addText(tooltip.getType());
        this.getShowGuns();
        this.addPackInfo();
    }

    private void addPackInfo() {
        PackInfo packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(attachmentId);
        if (packInfoObject != null) {
            packInfo = class_2561.method_43471(packInfoObject.getName()).method_27692(class_124.field_1078).method_27692(class_124.field_1056);
        }
    }

    private static List<class_1799> getAllAllowGuns(List<class_1799> output, class_2960 attachmentId) {
        class_1799 attachment = AttachmentItemBuilder.create().setId(attachmentId).build();
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            class_2960 gunId = entry.getKey();
            class_1799 gun = GunItemBuilder.create().setId(gunId).build();
            if (!(gun.method_7909() instanceof IGun iGun)) {
                return;
            }
            if (iGun.allowAttachment(gun, attachment)) {
                output.add(gun);
            }
        });
        return output;
    }

    @Override
    public int method_32661() {
        if (!class_437.method_25442()) {
            return components.size() * 10 + 28;
        }
        return (showGuns.size() - 1) / 16 * 18 + 50 + components.size() * 10;
    }

    @Override
    public int method_32664(class_327 font) {
        int[] width = new int[]{0};
        if (packInfo != null) {
            width[0] = Math.max(width[0], font.method_27525(packInfo) + 4);
        }
        components.forEach(c -> width[0] = Math.max(width[0], font.method_27525(c)));
        if (!class_437.method_25442()) {
            return Math.max(width[0], font.method_27525(tips) + 4);
        } else {
            width[0] = Math.max(width[0], font.method_27525(support) + 4);
        }
        if (showGuns.size() > 15) {
            return Math.max(width[0], 260);
        }
        return Math.max(width[0], showGuns.size() * 16 + 4);
    }

    @Override
    public void method_32665(class_327 font, int pX, int pY, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        int yOffset = pY;
        for (class_2561 component : this.components) {
            font.method_30882(component, pX, yOffset, 0xffaa00, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }
        if (!class_437.method_25442()) {
            font.method_30882(tips, pX, pY + 5 + this.components.size() * 10, 0x9e9e9e, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        } else {
            yOffset += (showGuns.size() - 1) / 16 * 18 + 32;
        }
        // 枪包名
        if (packInfo != null) {
            font.method_30882(this.packInfo, pX, yOffset + 8, 0xffffff, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    @Override
    public void method_32666(class_327 font, int mouseX, int mouseY, class_332 gui) {
        if (!class_437.method_25442()) {
            return;
        }
        int minY = components.size() * 10 + 3;
        int maxX = method_32664(font);
        gui.method_25294(mouseX, mouseY + minY, mouseX + maxX, mouseY + minY + 11, 0x8F00b0ff);
        gui.method_27535(font, support, mouseX + 2, mouseY + minY + 2, 0xe3f2fd);

        for (int i = 0; i < showGuns.size(); i++) {
            class_1799 stack = showGuns.get(i);
            int x = i % 16 * 16 + 2;
            int y = i / 16 * 18 + minY + 15;
            gui.method_51427(stack, mouseX + x, mouseY + y);
        }
    }

    private void getShowGuns() {
        try {
            this.showGuns = CACHE.get(attachmentId, () -> getAllAllowGuns(Lists.newArrayList(), attachmentId));
        } catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static String rgbToHex(int rgb) {
        int r = (rgb >> 16) & 0xFF;
        int g = (rgb >> 8) & 0xFF;
        int b = rgb & 0xFF;
        return String.format("#%02X%02X%02X", r, g, b);
    }

    private void addText(AttachmentType type) {
        TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresent(index -> {
            AttachmentData data = index.getData();

            @Nullable String tooltipKey = index.getTooltipKey();
            if (tooltipKey != null) {
                String text = class_1074.method_4662(tooltipKey);
                String[] split = text.split("\n");
                Arrays.stream(split).forEach(s -> components.add(class_2561.method_43470(s).method_27692(class_124.field_1080)));
            }

            if (attachment.method_7909() instanceof IAttachment iAttachment) {
                TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresent(attachmentIndex -> {
                    if (iAttachment.hasCustomLaserColor(attachment)) {
                        int color = iAttachment.getLaserColor(attachment);
                        components.add(class_2561.method_43469("tooltip.tacz.attachment.laser.color", rgbToHex(color)).method_27696(class_2583.field_24360.method_36139(color)));
                    } else if (attachmentIndex.getLaserConfig() != null) {
                        int color = attachmentIndex.getLaserConfig().getDefaultColor();
                        components.add(class_2561.method_43469("tooltip.tacz.attachment.laser.color", rgbToHex(color)).method_27696(class_2583.field_24360.method_36139(color)));
                    }
                });
            }

            if (type == AttachmentType.SCOPE) {
                float[] zoom = index.getZoom();
                if (zoom != null) {
                    String[] zoomText = new String[zoom.length];
                    for (int i = 0; i < zoom.length; i++) {
                        zoomText[i] = "x" + zoom[i];
                    }
                    String zoomJoinText = StringUtils.join(zoomText, ", ");
                    components.add(class_2561.method_43469("tooltip.tacz.attachment.zoom", zoomJoinText).method_27692(class_124.field_1065));
                }
            }

            if (type == AttachmentType.EXTENDED_MAG) {
                int magLevel = data.getExtendedMagLevel();
                if (magLevel == 1) {
                    components.add(class_2561.method_43471("tooltip.tacz.attachment.extended_mag_level_1").method_27692(class_124.field_1080));
                } else if (magLevel == 2) {
                    components.add(class_2561.method_43471("tooltip.tacz.attachment.extended_mag_level_2").method_27692(class_124.field_1078));
                } else if (magLevel == 3) {
                    components.add(class_2561.method_43471("tooltip.tacz.attachment.extended_mag_level_3").method_27692(class_124.field_1076));
                }
            }

            data.getModifier().forEach((key, value) -> {
                List<class_2561> result = value.getComponents();
                components.addAll(result);
            });
        });
    }
}
