package com.tacz.guns.compat.jei;

import com.tacz.guns.api.item.*;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import net.minecraft.class_1799;

public class GunModSubtype {
    public static IIngredientSubtypeInterpreter<class_1799> getAmmoSubtype() {
        return (stack, context) -> {
            if (stack.method_7909() instanceof IAmmo iAmmo) {
                return iAmmo.getAmmoId(stack).toString();
            }
            return IIngredientSubtypeInterpreter.NONE;
        };
    }

    public static IIngredientSubtypeInterpreter<class_1799> getGunSubtype() {
        return (stack, context) -> {
            if (stack.method_7909() instanceof IGun iGun) {
                return iGun.getGunId(stack).toString();
            }
            return IIngredientSubtypeInterpreter.NONE;
        };
    }

    public static IIngredientSubtypeInterpreter<class_1799> getAttachmentSubtype() {
        return (stack, context) -> {
            if (stack.method_7909() instanceof IAttachment iAttachment) {
                return iAttachment.getAttachmentId(stack).toString();
            }
            return IIngredientSubtypeInterpreter.NONE;
        };
    }

    public static IIngredientSubtypeInterpreter<class_1799> getTableSubType() {
        return (stack, context) -> {
            if (stack.method_7909() instanceof IBlock iBlock) {
                return iBlock.getBlockId(stack).toString();
            }
            return IIngredientSubtypeInterpreter.NONE;
        };
    }


    public static IIngredientSubtypeInterpreter<class_1799> getAmmoBoxSubtype() {
        return (stack, context) -> {
            if (stack.method_7909() instanceof IAmmoBox iAmmoBox) {
                if (iAmmoBox.isAllTypeCreative(stack)) {
                    return "all_type_creative";
                }
                if (iAmmoBox.isCreative(stack)) {
                    return "creative";
                }
                return String.format("level_%d", iAmmoBox.getAmmoLevel(stack));
            }
            return IIngredientSubtypeInterpreter.NONE;
        };
    }
}
