package com.tacz.guns.compat.kubejs.recipe;

import cn.sh1rocu.tacz.util.forge.CraftingHelper;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.compat.kubejs.util.GunSmithTableResultInfo;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import dev.latvian.mods.kubejs.item.InputItem;
import dev.latvian.mods.kubejs.item.OutputItem;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.recipe.RecipeJS;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import dev.latvian.mods.kubejs.util.JsonIO;
import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class TimelessRecipeJS extends RecipeJS {
    private String outputGroup = "";
    private GunSmithTableResultInfo info;

    public GunSmithTableResultInfo getResultInfo() {
        return info;
    }

    public void setResultInfo(GunSmithTableResultInfo info) {
        this.info = info;
    }

    /**
     * 设置后对配方结果的影响改至{@link GunSmithTableResultInfo}
     */
    public TimelessRecipeJS outputGroupName(String group) {
        getResultInfo().setGroupName(group);
        return this;
    }

    /**
     * 设置后对配方结果的影响改至{@link GunSmithTableResultInfo}
     */
    public TimelessRecipeJS outputGroup(GunSmithTableResultInfo.OutputGroupName group) {
        return outputGroupName(group.getName());
    }

    @Override
    public InputItem readInputItem(Object from) {
        if (from instanceof JsonObject jsonObject) {
            if (!jsonObject.has("item")) {
                throw new RecipeExceptionJS("Expected " + jsonObject + " must has a item member");
            }
            class_1856 ingredient = class_1856.method_52177(jsonObject.get("item"));
            int count = 1;
            if (jsonObject.has("count")) {
                count = Math.max(class_3518.method_15260(jsonObject, "count"), 1);
            }
            return InputItem.of(ingredient, count);
        } else {
            return super.readInputItem(from);
        }
    }

    @Override
    public JsonElement writeInputItem(InputItem value) {
        JsonObject jsonObject = new JsonObject();
        if (value.count > 1) {
            jsonObject.add("item", value.ingredient.method_8089());
            jsonObject.addProperty("count", value.count);
        } else {
            jsonObject.add("item", value.ingredient.method_8089());
        }
        return jsonObject;
    }

    @Deprecated
    @Override
    public OutputItem readOutputItem(Object from) {
        if (from instanceof JsonObject jsonObject) {
            String groupName = "";
            String typeName = class_3518.method_15265(jsonObject, "type");
            int count = 1;
            class_2487 extraTag = null;
            if (jsonObject.has("count")) {
                count = Math.max(class_3518.method_15260(jsonObject, "count"), 1);
            }
            if (jsonObject.has("nbt")) {
                extraTag = CraftingHelper.getNBT(jsonObject.get("nbt"));
            }
            class_1799 resultItemStack = class_1799.field_8037;
            switch (typeName) {
                case GunSmithTableResult.GUN -> {
                    groupName = getGunTypeFromJson(jsonObject);
                    resultItemStack = getGunItemFromJson(jsonObject);
                }
                case GunSmithTableResult.AMMO -> {
                    groupName = GunSmithTableResultInfo.OutputGroupName.AMMO.getName();
                    resultItemStack = getAmmoItemFromJson(jsonObject);
                }
                case GunSmithTableResult.ATTACHMENT -> {
                    groupName = getAttachmentTypeFromJson(jsonObject);
                    resultItemStack = getAttachmentItemFromJson(jsonObject);
                }
                case GunSmithTableResult.CUSTOM -> {
                    JsonObject resultObject = class_3518.method_15296(jsonObject, "item");
                    class_1799 itemStack = CraftingHelper.getItemStack(resultObject, true);
                    if (extraTag != null) {
                        itemStack.method_7980(extraTag);
                    }
                    resultItemStack = itemStack;
                }
            }
            if (jsonObject.has("group")) {
                groupName = class_3518.method_15265(jsonObject, "group");
            }
            if (!groupName.isEmpty()) {
                outputGroupName(groupName);
            }
            return OutputItem.of(resultItemStack).withCount(count);
        }
        return super.readOutputItem(from);
    }

    @Deprecated
    @Override
    public JsonElement writeOutputItem(OutputItem value) {
        JsonObject jsonObject = new JsonObject();
        JsonObject itemJson = new JsonObject();
        itemJson.addProperty("item", RegistryInfo.ITEM.getId(value.item.method_7909()).toString());
        itemJson.addProperty("count", value.getCount());
        if (JsonIO.of(value.getNbt()) != null) {
            itemJson.addProperty("nbt", value.getNbt().toString());
        }
        jsonObject.addProperty("type", "custom");
        jsonObject.add("item", itemJson);
        if (!outputGroup.isEmpty()) {
            jsonObject.addProperty("group", outputGroup);
        }
        return jsonObject;
    }

    private class_2960 getIdFromJson(JsonObject jsonObject) {
        return new class_2960(class_3518.method_15265(jsonObject, "id"));
    }

    private String getGunTypeFromJson(JsonObject jsonObject) {
        class_2960 gunId = getIdFromJson(jsonObject);
        return TimelessAPI.getCommonGunIndex(gunId).map(CommonGunIndex::getType).orElse("");
    }

    private class_1799 getGunItemFromJson(JsonObject jsonObject) {
        class_2960 gunId = getIdFromJson(jsonObject);
        int ammoCount;
        EnumMap<AttachmentType, class_2960> attachments;
        GunResult gunResult = CommonAssetsManager.GSON.fromJson(jsonObject, GunResult.class);
        if (gunResult != null) {
            ammoCount = Math.max(0, gunResult.getAmmoCount());
            attachments = gunResult.getAttachments();
        } else {
            ammoCount = 0;
            attachments = new EnumMap<>(AttachmentType.class);
        }
        return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex ->
                GunItemBuilder.create()
                        .setId(gunId)
                        .setAmmoCount(ammoCount)
                        .setAmmoInBarrel(false)
                        .putAllAttachment(attachments)
                        .setFireMode(gunIndex.getGunData().getFireModeSet().get(0))
                        .build()
        ).orElse(class_1799.field_8037);
    }

    private String getAttachmentTypeFromJson(JsonObject jsonObject) {
        class_2960 attachmentId = getIdFromJson(jsonObject);
        return TimelessAPI.getCommonAttachmentIndex(attachmentId).map(attachmentIndex ->
                attachmentIndex.getType()
                        .name()
                        .toLowerCase(Locale.US)
        ).orElse("");
    }

    private class_1799 getAttachmentItemFromJson(JsonObject jsonObject) {
        class_2960 attachmentId = getIdFromJson(jsonObject);
        return AttachmentItemBuilder.create().setId(attachmentId).build();
    }

    private class_1799 getAmmoItemFromJson(JsonObject jsonObject) {
        class_2960 ammoId = getIdFromJson(jsonObject);
        return AmmoItemBuilder.create().setId(ammoId).build();
    }
}