package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ServerMessageLevelUp implements FabricPacket {
    public static final PacketType<ServerMessageLevelUp> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "s2c_levelup"), ServerMessageLevelUp::new);

    private final class_1799 gun;
    private final int level;

    public ServerMessageLevelUp(class_2540 buf) {
        this(buf.method_10819(), buf.readInt());
    }

    public ServerMessageLevelUp(class_1799 gun, int level) {
        this.gun = gun;
        this.level = level;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10793(gun);
        buf.writeInt(level);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(EnvType.CLIENT)
    public void handle(class_746 player, PacketSender responseSender) {
        onLevelUp(this);
    }

    @Environment(EnvType.CLIENT)
    private static void onLevelUp(ServerMessageLevelUp message) {
        int level = message.getLevel();
        class_1799 gun = message.getGun();
        class_1657 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        // TODO 在完成了枪械升级逻辑后，解封下面的代码
                /*
                if (GunLevelManager.DAMAGE_UP_LEVELS.contains(level)) {
                    Minecraft.getInstance().getToasts().addToast(new GunLevelUpToast(gun,
                            Component.translatable("toast.tacz.level_up"),
                            Component.translatable("toast.tacz.sub.damage_up")));
                } else if (level >= GunLevelManager.MAX_LEVEL) {
                    Minecraft.getInstance().getToasts().addToast(new GunLevelUpToast(gun,
                            Component.translatable("toast.tacz.level_up"),
                            Component.translatable("toast.tacz.sub.final_level")));
                } else {
                    Minecraft.getInstance().getToasts().addToast(new GunLevelUpToast(gun,
                            Component.translatable("toast.tacz.level_up"),
                            Component.translatable("toast.tacz.sub.level_up")));
                }*/
    }

    public class_1799 getGun() {
        return this.gun;
    }

    public int getLevel() {
        return this.level;
    }
}
