package cn.sh1rocu.tacz.mixin.common;

import cn.sh1rocu.tacz.api.event.PlayerTickEvent;
import cn.sh1rocu.tacz.api.mixin.ForcePoseInjection;
import net.minecraft.class_1657;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public class PlayerMixin implements ForcePoseInjection {
    @Unique
    private class_4050 tacz$forcedPose;

    @Override
    public class_4050 tacz$getForcedPose() {
        return tacz$forcedPose;
    }

    @Override
    public void tacz$setForcedPose(class_4050 pose) {
        tacz$forcedPose = pose;
    }

    @Inject(method = "updatePlayerPose()V", at = @At("HEAD"), cancellable = true)
    public void tacz$updatePlayerPose(CallbackInfo ci) {
        if (tacz$forcedPose != null) {
            ((class_1657) (Object) this).method_18380(tacz$forcedPose);
            ci.cancel();
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    public void tacz$tickStartEvent(CallbackInfo ci) {
        PlayerTickEvent.START.invoker().onStart(new PlayerTickEvent.Pre((class_1657) (Object) this));
    }

    @Inject(method = "tick", at = @At("TAIL"))
    public void tacz$tickEndEvent(CallbackInfo ci) {
        PlayerTickEvent.END.invoker().onEnd(new PlayerTickEvent.Post((class_1657) (Object) this));
    }
}
