package cn.sh1rocu.tacz.mixin.common.itemhandler;

import cn.sh1rocu.tacz.util.forge.LazyOptional;
import cn.sh1rocu.tacz.util.itemhandler.CombinedInvWrapper;
import cn.sh1rocu.tacz.util.itemhandler.IItemHandler;
import cn.sh1rocu.tacz.util.itemhandler.entity.player.PlayerArmorInvWrapper;
import cn.sh1rocu.tacz.util.itemhandler.entity.player.PlayerInvWrapper;
import cn.sh1rocu.tacz.util.itemhandler.entity.player.PlayerMainInvWrapper;
import cn.sh1rocu.tacz.util.itemhandler.entity.player.PlayerOffhandInvWrapper;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends class_1309 {
    @Shadow
    @Final
    private class_1661 inventory;
    @Unique
    private LazyOptional<IItemHandler> playerMainHandler;
    @Unique
    private LazyOptional<IItemHandler> playerEquipmentHandler;
    @Unique
    private LazyOptional<IItemHandler> playerJoinedHandler;

    protected PlayerMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    private void tacz$initClass(class_1937 world, class_2338 pos, float yaw, GameProfile gameProfile, CallbackInfo ci) {
        this.playerMainHandler = LazyOptional.of(() ->
                new PlayerMainInvWrapper(this.inventory));
        this.playerEquipmentHandler = LazyOptional.of(() ->
                new CombinedInvWrapper(new PlayerArmorInvWrapper(this.inventory), new PlayerOffhandInvWrapper(this.inventory)));
        this.playerJoinedHandler = LazyOptional.of(() ->
                new PlayerInvWrapper(this.inventory));
    }

    @Override
    public LazyOptional<IItemHandler> tacz$getItemHandler(@Nullable class_2350 facing) {
        if (method_5805()) {
            if (facing == null) {
                return this.playerJoinedHandler.cast();
            }

            if (facing.method_10166().method_10178()) {
                return this.playerMainHandler.cast();
            }

            if (facing.method_10166().method_10179()) {
                return this.playerEquipmentHandler.cast();
            }
        }

        return super.tacz$getItemHandler(facing);
    }
}
