package com.tacz.guns.client.gameplay;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine;
import com.tacz.guns.api.event.common.GunFireSelectEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.client.animation.statemachine.GunAnimationConstant;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerFireSelect;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1799;
import net.minecraft.class_746;

public class LocalPlayerFireSelect {
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerFireSelect(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void fireSelect() {
        // 检查状态锁
        if (data.clientStateLock) {
            return;
        }
        // 暂定为主手
        class_1799 mainHandItem = player.method_6047();
        if (!(mainHandItem.method_7909() instanceof IGun iGun)) {
            return;
        }
        GunFireSelectEvent fireSelectEvent = new GunFireSelectEvent(player, player.method_6047(), LogicalSide.CLIENT);
        GunFireSelectEvent.CALLBACK.invoker().post(fireSelectEvent);
        if (fireSelectEvent.isCanceled()) {
            return;
        }

        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(gunIndex -> {
            // 播放音效
            SoundPlayManager.playFireSelectSound(player, gunIndex);
            // 发送切换开火模式的数据包，通知服务器
            ClientPlayNetworking.send(new ClientMessagePlayerFireSelect());
            // 客户端切换开火模式
            if (iGun instanceof AbstractGunItem logicGun) {
                logicGun.fireSelect(null, mainHandItem);
            }
            AttachmentPropertyManager.postChangeEvent(player, mainHandItem);
            // 动画状态机转移状态
            AnimationStateMachine<?> animationStateMachine = gunIndex.getAnimationStateMachine();
            if (animationStateMachine != null) {
                animationStateMachine.trigger(GunAnimationConstant.INPUT_FIRE_SELECT);
            }
        });
    }
}
