package com.tacz.guns.client.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.resource.CommonAssetsManager;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;

public class PackInfoManager extends class_4080<Map<String, PackInfo>> implements IdentifiableResourceReloadListener {
    private static final Marker MARKER = MarkerFactory.getMarker("PackInfoLoader");
    private static final String PACK_INFO_NAME = "gunpack_info.json";
    private final Map<String, PackInfo> dataMap = Maps.newHashMap();

    @Override
    protected Map<String, PackInfo> method_18789(class_3300 manager, class_3695 pProfiler) {
        Map<String, PackInfo> output = Maps.newHashMap();

        for (String namespaces : manager.method_14487()) {
            manager.method_14486(new class_2960(namespaces, PACK_INFO_NAME)).ifPresent(rl -> {
                try (Reader reader = rl.method_43039()) {
                    PackInfo packInfo = class_3518.method_15267(CommonAssetsManager.GSON, reader, PackInfo.class, true);
                    PackInfo packInfo1 = output.put(namespaces, packInfo);
                    if (packInfo1 != null) {
                        throw new IllegalStateException("Duplicate data file ignored with namespace " + namespaces);
                    }
                } catch (IllegalArgumentException | IOException | JsonParseException jsonparseexception) {
                    GunMod.LOGGER.error(MARKER, "Couldn't parse pack info for namespace '{}' from {}", namespaces, rl, jsonparseexception);
                }
            });
        }
        return output;
    }

    @Override
    protected void apply(Map<String, PackInfo> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        dataMap.clear();
        dataMap.putAll(pObject);
    }

    public PackInfo getData(String namespace) {
        return dataMap.get(namespace);
    }

    public static final class_2960 ID = new class_2960(GunMod.MOD_ID, "packinfo_manager");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}
