package com.tacz.guns.client.tooltip;

import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.inventory.tooltip.AmmoBoxTooltip;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5684;
import org.joml.Matrix4f;

public class ClientAmmoBoxTooltip implements class_5684 {
    private final class_1799 ammo;
    private final class_2561 count;
    private final class_2561 ammoName;

    public ClientAmmoBoxTooltip(AmmoBoxTooltip tooltip) {
        this.ammo = tooltip.getAmmo();
        class_1799 ammoBox = tooltip.getAmmoBox();
        if (ammoBox.method_7909() instanceof IAmmoBox box && box.isCreative(ammoBox)) {
            this.count = class_2561.method_43470("∞");
        } else {
            this.count = class_2561.method_43469("tooltip.tacz.ammo_box.count", tooltip.getCount());
        }
        this.ammoName = this.ammo.method_7964();
    }

    @Override
    public int method_32661() {
        return 28;
    }

    @Override
    public int method_32664(class_327 font) {
        return Math.max(font.method_27525(ammoName), font.method_27525(count)) + 22;
    }

    @Override
    public void method_32665(class_327 font, int pX, int pY, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        font.method_30882(ammoName, pX + 20, pY + 4, 0xffaa00, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        font.method_30882(count, pX + 20, pY + 15, 0x666666, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    @Override
    public void method_32666(class_327 pFont, int pX, int pY, class_332 pGuiGraphics) {
        pGuiGraphics.method_51427(ammo, pX, pY + 5);
    }
}
