package com.tacz.guns.client.tooltip;

import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.inventory.tooltip.BlockItemTooltip;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5684;

public class ClientBlockItemTooltip implements class_5684 {
    private final class_2960 blockId;
    private final List<class_2561> components = Lists.newArrayList();
    private @Nullable class_5250 packInfo;

    public ClientBlockItemTooltip(BlockItemTooltip tooltip) {
        this.blockId = tooltip.getBlockId();
        this.addText();
        this.addPackInfo();
    }

    private void addPackInfo() {
        PackInfo packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(blockId);
        if (packInfoObject != null) {
            packInfo = class_2561.method_43471(packInfoObject.getName()).method_27692(class_124.field_1078).method_27692(class_124.field_1056);
        }
    }


    @Override
    public int method_32661() {
        return components.size() * 10 + (packInfo != null ? 16 : 0);
    }

    @Override
    public int method_32664(class_327 font) {
        int[] width = new int[]{0};
        if (packInfo != null) {
            width[0] = Math.max(width[0], font.method_27525(packInfo) + 4);
        }
        components.forEach(c -> width[0] = Math.max(width[0], font.method_27525(c)));
        return width[0];
    }

    @Override
    public void method_32665(class_327 font, int pX, int pY, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        int yOffset = pY;
        for (class_2561 component : this.components) {
            font.method_30882(component, pX, yOffset, 0xffaa00, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }
        // 枪包名
        if (packInfo != null) {
            font.method_30882(this.packInfo, pX, yOffset + 6, 0xffffff, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    @Override
    public void method_32666(class_327 font, int mouseX, int mouseY, class_332 gui) {
    }

    private void addText() {
        TimelessAPI.getClientBlockIndex(blockId).ifPresent(index -> {
            @Nullable String tooltipKey = index.getTooltipKey();
            if (tooltipKey != null) {
                String text = class_1074.method_4662(tooltipKey);
                String[] split = text.split("\n");
                Arrays.stream(split).forEach(s -> components.add(class_2561.method_43470(s).method_27692(class_124.field_1080)));
            }
        });
    }
}
