package com.tacz.guns.util;

import com.tacz.guns.api.entity.ITargetEntity;
import com.tacz.guns.config.common.OtherConfig;
import java.util.LinkedList;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public final class HitboxHelper {
    // 玩家位置缓存表
    private static final WeakHashMap<class_1657, LinkedList<class_243>> PLAYER_POSITION = new WeakHashMap<>();
    // 玩家命中箱缓存表
    private static final WeakHashMap<class_1657, LinkedList<class_238>> PLAYER_HITBOXES = new WeakHashMap<>();
    // 玩家速度缓存表
    private static final WeakHashMap<class_1657, LinkedList<class_243>> PLAYER_VELOCITY = new WeakHashMap<>();
    // 命中箱缓存 Tick 上限
    private static final int SAVE_TICK = class_3532.method_15357(OtherConfig.SERVER_HITBOX_LATENCY_MAX_SAVE_MS.get() / 1000 * 20 + 0.5);

    public static void onPlayerTick(class_1657 player) {
        if (player.method_7325()) {
            PLAYER_POSITION.remove(player);
            PLAYER_HITBOXES.remove(player);
            PLAYER_VELOCITY.remove(player);
            return;
        }
        LinkedList<class_243> positions = PLAYER_POSITION.computeIfAbsent(player, p -> new LinkedList<>());
        LinkedList<class_238> boxes = PLAYER_HITBOXES.computeIfAbsent(player, p -> new LinkedList<>());
        LinkedList<class_243> velocities = PLAYER_VELOCITY.computeIfAbsent(player, p -> new LinkedList<>());
        positions.addFirst(player.method_19538());
        boxes.addFirst(player.method_5829());
        velocities.addFirst(getPlayerVelocity(player));
        // Position 用于速度计算，所以只需要缓存 2 个位置
        if (positions.size() > 2) {
            positions.removeLast();
        }
        // 命中箱和速度缓存数量限制
        if (boxes.size() > SAVE_TICK) {
            boxes.removeLast();
            velocities.removeLast();
        }
    }

    public static void onPlayerLoggedOut(class_1657 player) {
        PLAYER_POSITION.remove(player);
        PLAYER_HITBOXES.remove(player);
        PLAYER_VELOCITY.remove(player);
    }

    public static class_243 getPlayerVelocity(class_1657 entity) {
        LinkedList<class_243> positions = PLAYER_POSITION.computeIfAbsent(entity, player -> new LinkedList<>());
        if (positions.size() > 1) {
            class_243 currPos = positions.getFirst();
            class_243 prevPos = positions.getLast();
            return new class_243(currPos.field_1352 - prevPos.field_1352, currPos.field_1351 - prevPos.field_1351, currPos.field_1350 - prevPos.field_1350);
        }
        return new class_243(0, 0, 0);
    }

    public static class_238 getBoundingBox(class_1657 entity, int ping) {
        if (PLAYER_HITBOXES.containsKey(entity)) {
            LinkedList<class_238> boxes = PLAYER_HITBOXES.get(entity);
            int index = class_3532.method_15340(ping, 0, boxes.size() - 1);
            return boxes.get(index);
        }
        return entity.method_5829();
    }

    public static class_243 getVelocity(class_1657 entity, int ping) {
        if (PLAYER_VELOCITY.containsKey(entity)) {
            LinkedList<class_243> velocities = PLAYER_VELOCITY.get(entity);
            int index = class_3532.method_15340(ping, 0, velocities.size() - 1);
            return velocities.get(index);
        }
        return getPlayerVelocity(entity);
    }

    public static class_238 getFixedBoundingBox(class_1297 entity, class_1297 owner) {
        class_238 boundingBox = entity.method_5829();
        class_243 velocity = new class_243(entity.method_23317() - entity.field_6038, entity.method_23318() - entity.field_5971, entity.method_23321() - entity.field_5989);
        // hitbox 延迟补偿。只有射击者是玩家（且被击中者也是玩家）才进行此类延迟补偿计算
        if (OtherConfig.SERVER_HITBOX_LATENCY_FIX.get() && entity instanceof class_3222 player && owner instanceof class_3222 serverPlayerOwner) {
            int ping = class_3532.method_15357((serverPlayerOwner.field_13967 / 1000.0) * 20.0 + 0.5);
            boundingBox = getBoundingBox(player, ping);
            velocity = getVelocity(player, ping);
        }
        // 应用蹲伏导致的 hitbox 变形
        double expandHeight = entity instanceof class_1657 && !entity.method_18276() ? 0.0625 : 0.0;
        boundingBox = boundingBox.method_1012(0, expandHeight, 0);
        // 根据速度一定程度地扩展 hitbox
        boundingBox = boundingBox.method_1012(velocity.field_1352, velocity.field_1351, velocity.field_1350);
        // 玩家 hitbox 修正，可以通过 Config 调整
        double playerHitboxOffset = OtherConfig.SERVER_HITBOX_OFFSET.get();
        if (entity instanceof class_3222) {
            if (entity.method_5854() != null) {
                boundingBox = boundingBox.method_997(velocity.method_18805(playerHitboxOffset / 2, playerHitboxOffset / 2, playerHitboxOffset / 2));
            }
            boundingBox = boundingBox.method_997(velocity.method_18805(playerHitboxOffset, playerHitboxOffset, playerHitboxOffset));
        }
        // 给所有实体统一应用的 Hitbox 偏移，其数值为实验得出的定值。
        if (entity.method_5854() != null || entity instanceof ITargetEntity) {
            boundingBox = boundingBox.method_997(velocity.method_18805(-2.5, -2.5, -2.5));
        }
        boundingBox = boundingBox.method_997(velocity.method_18805(-5, -5, -5));
        return boundingBox;
    }
}
