/*
 * Decompiled with CFR 0.152.
 */
package cn.sh1rocu.tacz.util.forge;

import cn.sh1rocu.tacz.mixin.accessor.AbstractSliderButtonAccessor;
import java.text.DecimalFormat;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_357;

public class ForgeSlider
extends class_357 {
    protected class_2561 prefix;
    protected class_2561 suffix;
    protected double minValue;
    protected double maxValue;
    protected double stepSize;
    protected boolean drawString;
    private final DecimalFormat format;

    public ForgeSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, double stepSize, int precision, boolean drawString) {
        super(x, y, width, height, (class_2561)class_2561.method_43473(), 0.0);
        this.prefix = prefix;
        this.suffix = suffix;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.stepSize = Math.abs(stepSize);
        this.field_22753 = this.snapToNearest((currentValue - minValue) / (maxValue - minValue));
        this.drawString = drawString;
        if (stepSize == 0.0) {
            precision = Math.min(precision, 4);
            StringBuilder builder = new StringBuilder("0");
            if (precision > 0) {
                builder.append('.');
            }
            while (precision-- > 0) {
                builder.append('0');
            }
            this.format = new DecimalFormat(builder.toString());
        } else {
            this.format = class_3532.method_20390((double)this.stepSize, (double)Math.floor(this.stepSize)) ? new DecimalFormat("0") : new DecimalFormat(Double.toString(this.stepSize).replaceAll("\\d", "0"));
        }
        this.method_25346();
    }

    public ForgeSlider(int x, int y, int width, int height, class_2561 prefix, class_2561 suffix, double minValue, double maxValue, double currentValue, boolean drawString) {
        this(x, y, width, height, prefix, suffix, minValue, maxValue, currentValue, 1.0, 0, drawString);
    }

    public double getValue() {
        return this.field_22753 * (this.maxValue - this.minValue) + this.minValue;
    }

    public long getValueLong() {
        return Math.round(this.getValue());
    }

    public int getValueInt() {
        return (int)this.getValueLong();
    }

    public void setValue(double value) {
        this.field_22753 = this.snapToNearest((value - this.minValue) / (this.maxValue - this.minValue));
        this.method_25346();
    }

    public String getValueString() {
        return this.format.format(this.getValue());
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setValueFromMouse(mouseX);
    }

    protected void method_25349(double mouseX, double mouseY, double dragX, double dragY) {
        super.method_25349(mouseX, mouseY, dragX, dragY);
        this.setValueFromMouse(mouseX);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        boolean flag;
        boolean bl = flag = keyCode == 263;
        if (flag || keyCode == 262) {
            float f;
            if (this.minValue > this.maxValue) {
                flag = !flag;
            }
            float f2 = f = flag ? -1.0f : 1.0f;
            if (this.stepSize <= 0.0) {
                this.setSliderValue(this.field_22753 + (double)(f / (float)(this.field_22758 - 8)));
            } else {
                this.setValue(this.getValue() + (double)f * this.stepSize);
            }
        }
        return false;
    }

    private void setValueFromMouse(double mouseX) {
        this.setSliderValue((mouseX - (double)(this.method_46426() + 4)) / (double)(this.field_22758 - 8));
    }

    private void setSliderValue(double value) {
        double oldValue = this.field_22753;
        this.field_22753 = this.snapToNearest(value);
        if (!class_3532.method_20390((double)oldValue, (double)this.field_22753)) {
            this.method_25344();
        }
        this.method_25346();
    }

    private double snapToNearest(double value) {
        if (this.stepSize <= 0.0) {
            return class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        }
        value = class_3532.method_16436((double)class_3532.method_15350((double)value, (double)0.0, (double)1.0), (double)this.minValue, (double)this.maxValue);
        value = this.stepSize * (double)Math.round(value / this.stepSize);
        value = this.minValue > this.maxValue ? class_3532.method_15350((double)value, (double)this.maxValue, (double)this.minValue) : class_3532.method_15350((double)value, (double)this.minValue, (double)this.maxValue);
        return class_3532.method_33722((double)value, (double)this.minValue, (double)this.maxValue, (double)0.0, (double)1.0);
    }

    protected void method_25346() {
        if (this.drawString) {
            this.method_25355((class_2561)class_2561.method_43470((String)"").method_10852(this.prefix).method_27693(this.getValueString()).method_10852(this.suffix));
        } else {
            this.method_25355((class_2561)class_2561.method_43473());
        }
    }

    protected void method_25344() {
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_310 mc = class_310.method_1551();
        ForgeSlider.blitWithBorder(guiGraphics, AbstractSliderButtonAccessor.tacz$getSliderLocation(), this.method_46426(), this.method_46427(), 0, ((AbstractSliderButtonAccessor)((Object)this)).tacz$getTextureY(), this.field_22758, this.field_22759, 200, 20, 2, 3, 2, 2);
        ForgeSlider.blitWithBorder(guiGraphics, AbstractSliderButtonAccessor.tacz$getSliderLocation(), this.method_46426() + (int)(this.field_22753 * (double)(this.field_22758 - 8)), this.method_46427(), 0, ((AbstractSliderButtonAccessor)((Object)this)).tacz$getHandleTextureY(), 8, this.field_22759, 200, 20, 2, 3, 2, 2);
        this.method_49604(guiGraphics, mc.field_1772, 2, this.field_22763 ? 0xFFFFFF : 0xA0A0A0 | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24);
    }

    private static void blitWithBorder(class_332 guiGraphics, class_2960 texture, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder) {
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        guiGraphics.method_25302(texture, x, y, u, v, leftBorder, topBorder);
        guiGraphics.method_25302(texture, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder);
        guiGraphics.method_25302(texture, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder);
        guiGraphics.method_25302(texture, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            guiGraphics.method_25302(texture, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder);
            guiGraphics.method_25302(texture, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                guiGraphics.method_25302(texture, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            guiGraphics.method_25302(texture, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight);
            guiGraphics.method_25302(texture, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight);
        }
    }
}

