/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.ExtraMovementModifier;
import com.tacz.guns.resource.modifier.custom.WeightModifier;
import com.tacz.guns.resource.pojo.data.gun.MoveSpeed;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1799;
import net.minecraft.class_5134;

public class LivingEntitySpeedModifier {
    private static final UUID EXTRA_SPEED_MODIFIER_UUID = UUID.fromString("4D5696AE-A7C5-C59C-80E9-2A2DC8373C46");
    private static final UUID WEIGHT_SPEED_MODIFIER_UUID = UUID.fromString("2CB6F5AD-C6D2-9D29-4E84-0856ACD47CDB");
    private final class_1309 shooter;
    private final ShooterDataHolder dataHolder;

    public LivingEntitySpeedModifier(class_1309 shooter, ShooterDataHolder dataHolder) {
        this.shooter = shooter;
        this.dataHolder = dataHolder;
    }

    public void updateSpeedModifier() {
        if (!this.shooter.method_5805()) {
            return;
        }
        class_1799 stack = this.shooter.method_6047();
        class_1324 speedModifier = this.shooter.method_6127().method_26842(class_5134.field_23719);
        if (speedModifier == null) {
            return;
        }
        if (stack.method_7909() instanceof AbstractGunItem) {
            AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity(this.shooter).getCacheProperty();
            if (cacheProperty != null) {
                MoveSpeed speed;
                double weightFactor = (Double)SyncConfig.WEIGHT_SPEED_MULTIPLIER.get();
                if (weightFactor > 0.0) {
                    float targetSpeed = ((Float)cacheProperty.getCache(WeightModifier.ID)).floatValue();
                    class_1322 currentModifier = speedModifier.method_6199(WEIGHT_SPEED_MODIFIER_UUID);
                    if (currentModifier == null || currentModifier.method_6186() != (double)(targetSpeed *= (float)(-weightFactor))) {
                        speedModifier.method_6200(WEIGHT_SPEED_MODIFIER_UUID);
                        speedModifier.method_26835(new class_1322(WEIGHT_SPEED_MODIFIER_UUID, "Gun Speed Modifier", (double)targetSpeed, class_1322.class_1323.field_6330));
                    }
                }
                if ((speed = (MoveSpeed)cacheProperty.getCache(ExtraMovementModifier.ID)) != null) {
                    double targetSpeed = this.getTargetSpeed(speed);
                    class_1322 currentModifier = speedModifier.method_6199(EXTRA_SPEED_MODIFIER_UUID);
                    if (currentModifier == null || currentModifier.method_6186() != targetSpeed) {
                        speedModifier.method_6200(EXTRA_SPEED_MODIFIER_UUID);
                        speedModifier.method_26835(new class_1322(EXTRA_SPEED_MODIFIER_UUID, "Extra Gun Speed Modifier", targetSpeed, class_1322.class_1323.field_6331));
                    }
                }
            }
        } else {
            speedModifier.method_6200(WEIGHT_SPEED_MODIFIER_UUID);
            speedModifier.method_6200(EXTRA_SPEED_MODIFIER_UUID);
        }
    }

    private double getTargetSpeed(MoveSpeed moveSpeed) {
        if (this.dataHolder.reloadStateType.isReloading()) {
            return moveSpeed.getReloadMultiplier();
        }
        if (this.dataHolder.isAiming) {
            return moveSpeed.getAimMultiplier();
        }
        return moveSpeed.getBaseMultiplier();
    }
}

