package com.tacz.guns.api.client.other;

import net.minecraft.class_1799;
import net.minecraft.class_310;

/**
 * 用来在收物品时，让其保持一段时间渲染的接口
 */
public interface KeepingItemRenderer {
    /**
     * 物品保持渲染的时间
     *
     * @param itemStack 保持的物品
     * @param timeMs    时间，单位毫秒
     */
    void keep(class_1799 itemStack, long timeMs);

    /**
     * 获取当前主手正在渲染的物品
     */
    class_1799 getCurrentItem();

    /**
     * ItemInHandRenderer 通过 Mixin 的方式实现了此接口。
     * @return 返回 ItemInHandRenderer 实例
     */
    static KeepingItemRenderer getRenderer(){
        return (KeepingItemRenderer) class_310.method_1551().method_1561().method_43336();
    }
}
