package com.tacz.guns.client.tooltip;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.client.input.RefitKey;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.client.resource.pojo.display.gun.DamageStyle;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.inventory.tooltip.GunTooltip;
import com.tacz.guns.item.GunTooltipPart;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.BulletData;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class ClientGunTooltip implements class_5684 {
    private static final DecimalFormat FORMAT = new DecimalFormat("#.##%");
    private static final DecimalFormat FORMAT_P_D1 = new DecimalFormat("#.#%");
    private static final DecimalFormat DAMAGE_FORMAT = new DecimalFormat("#.##");
    private static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("0%");

    private final class_1799 gun;
    private final IGun iGun;
    private final CommonGunIndex gunIndex;
    private final @Nullable GunDisplayInstance display;
    private final class_1799 ammo;
    private @Nullable List<class_5481> desc;
    private class_2561 ammoName;
    private class_5250 ammoCountText;
    private @Nullable class_5250 gunType;
    private class_5250 damage;
    private class_5250 armorIgnore;
    private class_5250 headShotMultiplier;
    private class_5250 weight;
    private class_5250 tips;
    private class_5250 levelInfo;
    private @Nullable class_5250 packInfo;

    private int maxWidth;

    public ClientGunTooltip(GunTooltip tooltip) {
        this.gun = tooltip.getGun();
        this.iGun = tooltip.getIGun();
        class_2960 ammoId = tooltip.getAmmoId();
        this.gunIndex = tooltip.getGunIndex();
        this.display = TimelessAPI.getGunDisplay(gun).orElse(null);
        this.ammo = AmmoItemBuilder.create().setId(ammoId).build();
        this.maxWidth = 0;
        this.getText();
    }

    @Override
    public int method_32661() {
        int height = 0;
        if (shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
            height += 10 * this.desc.size() + 2;
        }
        if (shouldShow(GunTooltipPart.AMMO_INFO)) {
            height += 24;
        }
        if (shouldShow(GunTooltipPart.BASE_INFO)) {
            height += 34;
        }
        if (shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            height += 34;
        }
        if (shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            height += 14;
        }
        if (shouldShow(GunTooltipPart.PACK_INFO)) {
            height += 14;
        }
        return height;
    }

    @Override
    public int method_32664(class_327 font) {
        return this.maxWidth;
    }

    private void getText() {
        class_327 font = class_310.method_1551().field_1772;
        BulletData bulletData = gunIndex.getBulletData();
        GunData gunData = gunIndex.getGunData();

        if (shouldShow(GunTooltipPart.DESCRIPTION)) {
            @Nullable String tooltip = gunIndex.getPojo().getTooltip();
            if (tooltip != null) {
                List<class_5481> split = font.method_1728(class_2561.method_43471(tooltip), 300);
                if (split.size() > 3) {
                    this.desc = split.subList(0, 3);
                } else {
                    this.desc = split;
                }
                for (class_5481 sequence : this.desc) {
                    this.maxWidth = Math.max(font.method_30880(sequence), this.maxWidth);
                }
            }
        }


        if (shouldShow(GunTooltipPart.AMMO_INFO)) {
            this.ammoName = ammo.method_7964();
            this.maxWidth = Math.max(font.method_27525(this.ammoName) + 22, this.maxWidth);

            int barrelBulletAmount = (iGun.hasBulletInBarrel(gun) && gunIndex.getGunData().getBolt() != Bolt.OPEN_BOLT) ? 1 : 0;
            int maxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(gun, gunIndex.getGunData()) + barrelBulletAmount;
            int currentAmmoCount = iGun.getCurrentAmmoCount(this.gun) + barrelBulletAmount;

            if (!iGun.useDummyAmmo(gun)) {
                if (display != null && display.getAmmoCountStyle()== AmmoCountStyle.PERCENT) {
                    this.ammoCountText = class_2561.method_43470(CURRENT_AMMO_FORMAT_PERCENT.format((float) currentAmmoCount / (maxAmmoCount == 0 ? 1f : maxAmmoCount)));
                } else {
                    this.ammoCountText = class_2561.method_43470("%d/%d".formatted(currentAmmoCount, maxAmmoCount));
                }
            } else {
                int dummyAmmoAmount = iGun.getDummyAmmoAmount(gun);
                if (display != null && display.getAmmoCountStyle()== AmmoCountStyle.PERCENT) {
                    String p = CURRENT_AMMO_FORMAT_PERCENT.format((float) currentAmmoCount / (maxAmmoCount == 0 ? 1f : maxAmmoCount));
                    this.ammoCountText = class_2561.method_43470("%s (%d)".formatted(p, dummyAmmoAmount));
                } else {
                    this.ammoCountText = class_2561.method_43470("%d/%d (%d)".formatted(currentAmmoCount, maxAmmoCount, dummyAmmoAmount));
                }

            }
            if (iGun.useInventoryAmmo(gun)) {
                this.ammoCountText = class_2561.method_43471("tooltip.tacz.gun.inventory_mode").method_27692(class_124.field_1054);
            }
            this.maxWidth = Math.max(font.method_27525(this.ammoCountText) + 22, this.maxWidth);
        }


        if (shouldShow(GunTooltipPart.BASE_INFO)) {
            int expToNextLevel = iGun.getExpToNextLevel(gun);
            int expCurrentLevel = iGun.getExpCurrentLevel(gun);
            int level = iGun.getLevel(gun);
            if (level >= iGun.getMaxLevel()) {
                String levelText = String.format("%d (MAX)", level);
                this.levelInfo = class_2561.method_43471("tooltip.tacz.gun.level").method_10852(class_2561.method_43470(levelText).method_27692(class_124.field_1064));
            } else {
                String levelText = String.format("%d (%.1f%%)", level, expCurrentLevel / (expToNextLevel + expCurrentLevel) * 100f);
                this.levelInfo = class_2561.method_43471("tooltip.tacz.gun.level").method_10852(class_2561.method_43470(levelText).method_27692(class_124.field_1054));
            }
            this.maxWidth = Math.max(font.method_27525(this.levelInfo), this.maxWidth);

            String tabKey = "tacz.type." + gunIndex.getType() + ".name";
            this.gunType = class_2561.method_43471("tooltip.tacz.gun.type").method_10852(class_2561.method_43471(tabKey).method_27692(class_124.field_1075));
            this.maxWidth = Math.max(font.method_27525(this.gunType), this.maxWidth);

            double damage = AttachmentDataUtils.getDamageWithAttachment(gun, gunData);
            int bulletAmount = gunData.getBulletData().getBulletAmount();
            class_5250 value;
            if (display != null && display.getDamageStyle() == DamageStyle.PER_PROJECTILE && bulletAmount > 1) {
                value = class_2561.method_43470(DAMAGE_FORMAT.format(damage/bulletAmount) + "x" + bulletAmount).method_27692(class_124.field_1075);
            } else {
                value = class_2561.method_43470(DAMAGE_FORMAT.format(damage)).method_27692(class_124.field_1075);
            }
            if (bulletData.getExplosionData() != null && (AttachmentDataUtils.isExplodeEnabled(gun, gunData) || bulletData.getExplosionData().isExplode())) {
                value.method_27693(" + ").method_27693(DAMAGE_FORMAT.format(bulletData.getExplosionData().getDamage() * SyncConfig.DAMAGE_BASE_MULTIPLIER.get())).method_10852(class_2561.method_43471("tooltip.tacz.gun.explosion"));
            }
            this.damage = class_2561.method_43471("tooltip.tacz.gun.damage").method_10852(value);
            this.maxWidth = Math.max(font.method_27525(this.damage), this.maxWidth);
        }


        if (shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            @Nullable ExtraDamage extraDamage = bulletData.getExtraDamage();
            if (extraDamage != null) {
                double armorDamagePercent = AttachmentDataUtils.getArmorIgnoreWithAttachment(gun, gunData);
                double headShotMultiplierPercent = AttachmentDataUtils.getHeadshotMultiplier(gun, gunData);

                armorDamagePercent = class_3532.method_15350(armorDamagePercent, 0.0F, 1.0F);

                this.armorIgnore = class_2561.method_43469("tooltip.tacz.gun.armor_ignore", FORMAT.format(armorDamagePercent));
                this.headShotMultiplier = class_2561.method_43469("tooltip.tacz.gun.head_shot_multiplier", FORMAT.format(headShotMultiplierPercent));
            } else {
                this.armorIgnore = class_2561.method_43469("tooltip.tacz.gun.armor_ignore", FORMAT.format(0));
                this.headShotMultiplier = class_2561.method_43469("tooltip.tacz.gun.head_shot_multiplier", FORMAT.format(1));
            }

            double weightFactor = SyncConfig.WEIGHT_SPEED_MULTIPLIER.get();
            double weight = AttachmentDataUtils.getWightWithAttachment(gun, gunData);
            this.weight = class_2561.method_43469("tooltip.tacz.gun.movement_speed", FORMAT_P_D1.format(-weightFactor * weight)).method_27692(class_124.field_1061);

            this.maxWidth = Math.max(font.method_27525(this.armorIgnore), this.maxWidth);
            this.maxWidth = Math.max(font.method_27525(this.headShotMultiplier), this.maxWidth);
            this.maxWidth = Math.max(font.method_27525(this.weight), this.maxWidth);
        }


        if (shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            String keyName = class_2561.method_43472(RefitKey.REFIT_KEY.method_1431()).getString().toUpperCase(Locale.ENGLISH);
            this.tips = class_2561.method_43469("tooltip.tacz.gun.tips", keyName).method_27692(class_124.field_1054).method_27692(class_124.field_1056);
            this.maxWidth = Math.max(font.method_27525(this.tips), this.maxWidth);
        }


        if (shouldShow(GunTooltipPart.PACK_INFO)) {
            class_2960 gunId = iGun.getGunId(gun);
            PackInfo packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(gunId);
            if (packInfoObject != null) {
                packInfo = class_2561.method_43471(packInfoObject.getName()).method_27692(class_124.field_1078).method_27692(class_124.field_1056);
                this.maxWidth = Math.max(font.method_27525(this.packInfo), this.maxWidth);
            }
        }
    }

    @Override
    public void method_32665(class_327 font, int pX, int pY, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        int yOffset = pY;

        if (shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
            yOffset += 2;
            for (class_5481 sequence : this.desc) {
                font.method_22942(sequence, pX, yOffset, 0xaaaaaa, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                yOffset += 10;
            }
        }


        if (shouldShow(GunTooltipPart.AMMO_INFO)) {
            yOffset += 4;

            // 弹药名
            font.method_30882(this.ammoName, pX + 20, yOffset, 0xffaa00, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);

            // 弹药数
            font.method_30882(this.ammoCountText, pX + 20, yOffset + 10, 0x777777, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);

            yOffset += 20;
        }


        if (shouldShow(GunTooltipPart.BASE_INFO)) {
            yOffset += 4;

            // 等级信息
            font.method_30882(this.levelInfo, pX, yOffset, 0x777777, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;

            // 枪械类型
            if (this.gunType != null) {
                font.method_30882(this.gunType, pX, yOffset, 0x777777, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
                yOffset += 10;
            }

            // 伤害
            font.method_30882(this.damage, pX, yOffset, 0x777777, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }


        if (shouldShow(GunTooltipPart.EXTRA_DAMAGE_INFO)) {
            yOffset += 4;

            // 穿甲伤害
            font.method_30882(this.armorIgnore, pX, yOffset, 0xffaa00, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;

            // 爆头伤害
            font.method_30882(this.headShotMultiplier, pX, yOffset, 0xffaa00, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;

            font.method_30882(this.weight, pX, yOffset, 0xffffff, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }


        if (shouldShow(GunTooltipPart.UPGRADES_TIP)) {
            yOffset += 4;

            // Z 键说明
            font.method_30882(this.tips, pX, yOffset, 0xffffff, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }


        if (shouldShow(GunTooltipPart.PACK_INFO)) {
            // 枪包名
            if (packInfo != null) {
                yOffset += 4;
                font.method_30882(this.packInfo, pX, yOffset, 0xffffff, false, matrix4f, bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            }
        }
    }

    @Override
    public void method_32666(class_327 pFont, int pX, int pY, class_332 guiGraphics) {
        IGun iGun = IGun.getIGunOrNull(this.gun);
        if (iGun == null) {
            return;
        }
        if (shouldShow(GunTooltipPart.AMMO_INFO)) {
            int yOffset = pY;
            if (shouldShow(GunTooltipPart.DESCRIPTION) && this.desc != null) {
                yOffset += this.desc.size() * 10 + 2;
            }
            guiGraphics.method_51427(ammo, pX, yOffset + 4);
        }
    }

    private boolean shouldShow(GunTooltipPart part) {
        return (GunTooltipPart.getHideFlags(this.gun) & part.getMask()) == 0;
    }
}
