package com.tacz.guns.command.sub;

import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.item.GunTooltipPart;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2300;

public class HideTooltipPartCommand {
    private static final String HIDE_TOOLTIP_PART_NAME = "hide_tooltip_part";
    private static final String ENTITY = "target";
    private static final String MASK = "mask";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> base = class_2170.method_9247(HIDE_TOOLTIP_PART_NAME);
        RequiredArgumentBuilder<class_2168, class_2300> entities = class_2170.method_9244(ENTITY, class_2186.method_9306());
        RequiredArgumentBuilder<class_2168, Integer> part = class_2170.method_9244(MASK, IntegerArgumentType.integer(0));
        base.then(entities.then(part.executes(HideTooltipPartCommand::setHide)));
        return base;
    }

    private static int setHide(CommandContext<class_2168> context) throws CommandSyntaxException {
        var entities = class_2186.method_9317(context, ENTITY);
        int cnt = 0;
        int mask = IntegerArgumentType.getInteger(context, MASK);
        for (class_1297 entity : entities) {
            if (entity instanceof class_1309 living) {
                class_1799 stack = living.method_6047();
                if (stack.method_7909() instanceof IGun) {
                    GunTooltipPart.setHideFlags(stack, mask);
                    cnt++;
                }
            }
        }
        return cnt;
    }
}
