package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.entity.IGunOperator;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClientMessagePlayerShoot implements FabricPacket {
    public static final PacketType<ClientMessagePlayerShoot> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "c2s_player_shoot"), ClientMessagePlayerShoot::new);

    /**
     * 这里的 timestamp 应该是基于 base timestamp 的相对值
     */
    private final long timestamp;

    public ClientMessagePlayerShoot(long timestamp) {
        this.timestamp = timestamp;
    }

    public ClientMessagePlayerShoot(class_2540 buf) {
        this(buf.readLong());
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeLong(timestamp);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        IGunOperator.fromLivingEntity(player).shoot(player::method_36455, player::method_36454, timestamp);
    }
}
