package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.client.sound.SoundPlayManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_746;

public class ServerMessageSound implements FabricPacket {
    public static final PacketType<ServerMessageSound> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "s2c_sound"), ServerMessageSound::new);

    private final int entityId;
    private final class_2960 gunId;
    private final class_2960 gunDisplayId;
    private final String soundName;
    private final float volume;
    private final float pitch;
    private final int distance;

    public ServerMessageSound(class_2540 buf) {
        this(buf.method_10816(), buf.method_10810(), buf.method_10810(), buf.method_19772(), buf.readFloat(), buf.readFloat(), buf.readInt());
    }

    public ServerMessageSound(int entityId, class_2960 gunId, class_2960 gunDisplayId, String soundName, float volume, float pitch, int distance) {
        this.entityId = entityId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
        this.soundName = soundName;
        this.volume = volume;
        this.pitch = pitch;
        this.distance = distance;
    }

    public ServerMessageSound(int entityId, class_2960 gunId, String soundName, float volume, float pitch, int distance) {
        this(entityId, gunId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID, soundName, volume, pitch, distance);
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10804(entityId);
        buf.method_10812(gunId);
        buf.method_10812(gunDisplayId);
        buf.method_10814(soundName);
        buf.writeFloat(volume);
        buf.writeFloat(pitch);
        buf.writeInt(distance);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(EnvType.CLIENT)
    public void handle(class_746 player, PacketSender responseSender) {
         SoundPlayManager.playMessageSound(this);
    }

    public int getEntityId() {
        return entityId;
    }

    public class_2960 getGunId() {
        return gunId;
    }

    public class_2960 getGunDisplayId() {
        return gunDisplayId;
    }

    public String getSoundName() {
        return soundName;
    }

    public float getVolume() {
        return volume;
    }

    public float getPitch() {
        return pitch;
    }

    public int getDistance() {
        return distance;
    }
}
