/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.tooltip;

import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.inventory.tooltip.BlockItemTooltip;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5684;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ClientBlockItemTooltip
implements class_5684 {
    private final class_2960 blockId;
    private final List<class_2561> components = Lists.newArrayList();
    @Nullable
    private class_5250 packInfo;

    public ClientBlockItemTooltip(BlockItemTooltip tooltip) {
        this.blockId = tooltip.getBlockId();
        this.addText();
        this.addPackInfo();
    }

    private void addPackInfo() {
        PackInfo packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(this.blockId);
        if (packInfoObject != null) {
            this.packInfo = class_2561.method_43471((String)packInfoObject.getName()).method_27692(class_124.field_1078).method_27692(class_124.field_1056);
        }
    }

    public int method_32661() {
        return this.components.size() * 10 + (this.packInfo != null ? 16 : 0);
    }

    public int method_32664(class_327 font) {
        int[] width = new int[]{0};
        if (this.packInfo != null) {
            width[0] = Math.max(width[0], font.method_27525((class_5348)this.packInfo) + 4);
        }
        this.components.forEach(c -> {
            width[0] = Math.max(width[0], font.method_27525((class_5348)c));
        });
        return width[0];
    }

    public void method_32665(class_327 font, int pX, int pY, Matrix4f matrix4f, class_4597.class_4598 bufferSource) {
        int yOffset = pY;
        for (class_2561 component : this.components) {
            font.method_30882(component, (float)pX, (float)yOffset, 0xFFAA00, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
            yOffset += 10;
        }
        if (this.packInfo != null) {
            font.method_30882((class_2561)this.packInfo, (float)pX, (float)(yOffset + 6), 0xFFFFFF, false, matrix4f, (class_4597)bufferSource, class_327.class_6415.field_33993, 0, 0xF000F0);
        }
    }

    public void method_32666(class_327 font, int mouseX, int mouseY, class_332 gui) {
    }

    private void addText() {
        TimelessAPI.getClientBlockIndex(this.blockId).ifPresent(index -> {
            @Nullable String tooltipKey = index.getTooltipKey();
            if (tooltipKey != null) {
                String text = class_1074.method_4662((String)tooltipKey, (Object[])new Object[0]);
                String[] split = text.split("\n");
                Arrays.stream(split).forEach(s -> this.components.add((class_2561)class_2561.method_43470((String)s).method_27692(class_124.field_1080)));
            }
        });
    }
}

