/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource.index;

import com.google.common.base.Preconditions;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.pojo.BlockIndexPOJO;
import com.tacz.guns.resource.pojo.data.block.BlockData;
import net.minecraft.class_1747;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class CommonBlockIndex {
    private BlockIndexPOJO pojo;
    private class_1747 block;
    private BlockData data;
    private RecipeFilter filter;

    public static CommonBlockIndex getInstance(BlockIndexPOJO gunIndexPOJO) throws IllegalArgumentException {
        CommonBlockIndex index = new CommonBlockIndex();
        index.pojo = gunIndexPOJO;
        CommonBlockIndex.checkIndex(gunIndexPOJO, index);
        CommonBlockIndex.checkData(gunIndexPOJO, index);
        return index;
    }

    private static void checkIndex(BlockIndexPOJO block, CommonBlockIndex index) {
        class_2960 id = index.pojo.getId();
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"index object file is empty");
        Object object = class_7923.field_41178.method_10223(id);
        if (!(object instanceof class_1747)) {
            throw new IllegalArgumentException("BlockItem not found for " + block.getName());
        }
        class_1747 item = (class_1747)object;
        index.block = item;
    }

    private static void checkData(BlockIndexPOJO block, CommonBlockIndex index) {
        class_2960 pojoData = block.getData();
        Preconditions.checkArgument((pojoData != null ? 1 : 0) != 0, (Object)"index object missing pojoData field");
        BlockData data = CommonAssetsManager.get().getBlockData(pojoData);
        Preconditions.checkArgument((data != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        RecipeFilter recipeFilter = CommonAssetsManager.get().getRecipeFilter(data.getFilter());
        Preconditions.checkArgument((recipeFilter != null ? 1 : 0) != 0, (Object)"there is no corresponding data file");
        index.data = data;
        index.filter = recipeFilter;
    }

    public BlockIndexPOJO getPojo() {
        return this.pojo;
    }

    public class_1747 getBlock() {
        return this.block;
    }

    public BlockData getData() {
        return this.data;
    }

    public RecipeFilter getFilter() {
        return this.filter;
    }
}

