package cn.sh1rocu.tacz.mixin.common.itemhandler;

import cn.sh1rocu.tacz.api.mixin.ItemHandlerCapability;
import cn.sh1rocu.tacz.util.forge.LazyOptional;
import cn.sh1rocu.tacz.util.itemhandler.IItemHandler;
import cn.sh1rocu.tacz.util.itemhandler.entity.EntityEquipmentInvWrapper;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin implements ItemHandlerCapability {
    @Shadow
    public abstract boolean isAlive();

    @Unique
    private LazyOptional<?>[] handlers;

    @Inject(method = "<init>", at = @At("TAIL"))
    private void tacz$initClass(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo ci) {
        handlers = EntityEquipmentInvWrapper.create(self());
    }

    @Override
    public LazyOptional<IItemHandler> tacz$getItemHandler(@Nullable class_2350 facing) {
        if (isAlive()) {
            if (facing == null) {
                return this.handlers[2].cast();
            }

            if (facing.method_10166().method_10178()) {
                return this.handlers[0].cast();
            }

            if (facing.method_10166().method_10179()) {
                return this.handlers[1].cast();
            }
        }

        return LazyOptional.empty();
    }

    @Override
    public void tacz$invalidateItemHandler() {
        for (LazyOptional<?> handler : this.handlers) {
            handler.invalidate();
        }
    }

    @Override
    public void tacz$reviveItemHandler() {
        this.handlers = EntityEquipmentInvWrapper.create(self());
    }

    @Unique
    private class_1309 self() {
        return (class_1309) (Object) this;
    }
}
