package com.tacz.guns.client.event;

import com.tacz.guns.api.item.nbt.AmmoItemDataAccessor;
import com.tacz.guns.api.item.nbt.AttachmentItemDataAccessor;
import com.tacz.guns.api.item.nbt.BlockItemDataAccessor;
import com.tacz.guns.api.item.nbt.GunItemDataAccessor;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.init.ModItems;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class TooltipEvent {
    public static void onTooltip(class_1799 stack, class_1836 context, List<class_2561> lines) {
        if (context.method_8035() && RenderConfig.ENABLE_TACZ_ID_IN_TOOLTIP.get()) {
            if (stack.method_7909() instanceof GunItemDataAccessor item) {
                lines.add(formatTooltip(GunItemDataAccessor.GUN_ID_TAG, item.getGunId(stack)));
            } else if (stack.method_7909() instanceof AmmoItemDataAccessor item) {
                lines.add(formatTooltip(AmmoItemDataAccessor.AMMO_ID_TAG, item.getAmmoId(stack)));
            } else if (stack.method_7909() instanceof AttachmentItemDataAccessor item) {
                lines.add(formatTooltip(AttachmentItemDataAccessor.ATTACHMENT_ID_TAG, item.getAttachmentId(stack)));
            } else if (stack.method_7909() instanceof BlockItemDataAccessor item && !ModItems.GUN_SMITH_TABLE.equals(item)) {
                lines.add(formatTooltip(BlockItemDataAccessor.BLOCK_ID, item.getBlockId(stack)));
            }
        }
    }

    public static class_2561 formatTooltip(String key, class_2960 value) {
        return class_2561.method_43470(String.format("%s: \"%s\"", key, value)).method_27692(class_124.field_1063);
    }
}
