package com.tacz.guns.client.gui.components.refit;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.gui.GunRefitScreen;
import org.jetbrains.annotations.NotNull;

import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class GunAttachmentSlot extends class_4185 implements IStackTooltip {
    private final AttachmentType type;
    private final class_1661 inventory;
    private final int gunItemIndex;
    private final String nameKey;
    private boolean selected = false;
    private class_1799 attachmentItem = class_1799.field_8037;

    public GunAttachmentSlot(int pX, int pY, AttachmentType type, int gunItemIndex, class_1661 inventory, class_4185.class_4241 onPress) {
        super(pX, pY, GunRefitScreen.SLOT_SIZE, GunRefitScreen.SLOT_SIZE, class_2561.method_43473(), onPress, class_4185.field_40754);
        this.type = type;
        this.inventory = inventory;
        this.gunItemIndex = gunItemIndex;
        this.nameKey = String.format("tooltip.tacz.attachment.%s", type.name().toLowerCase(Locale.US));
    }

    @Override
    public void renderTooltip(Consumer<class_1799> consumer) {
        if (this.method_25367() && !attachmentItem.method_7960()) {
            consumer.accept(attachmentItem);
        }
    }

    @Override
    public void method_48579(@NotNull class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.method_25367()) {
            class_327 font = class_310.method_1551().field_1772;
            int yOffset = this.method_46427() + 20;
            if (this.selected && !attachmentItem.method_7960()) {
                yOffset = this.method_46427() + 30;
            }
            graphics.method_27534(font, class_2561.method_43471(nameKey), this.method_46426() + this.method_25368() / 2, yOffset, class_124.field_1068.method_532());
        }
        class_1799 gunItem = inventory.method_5438(gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return;
        }

        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        // 渲染外框
        int x = this.method_46426();
        int y = this.method_46427();
        if (method_25367() || selected) {
            graphics.method_25290(GunRefitScreen.SLOT_TEXTURE, x, y, 0, 0, field_22758, field_22759, GunRefitScreen.SLOT_SIZE, GunRefitScreen.SLOT_SIZE);
        } else {
            graphics.method_25290(GunRefitScreen.SLOT_TEXTURE, x + 1, y + 1, 1, 1, field_22758 - 2, field_22759 - 2, GunRefitScreen.SLOT_SIZE, GunRefitScreen.SLOT_SIZE);
        }
        // 渲染内部物品，或者空置时的icon
        this.attachmentItem = iGun.getAttachment(gunItem, type);
        if (!attachmentItem.method_7960()) {
            graphics.method_51427(attachmentItem, x + 1, y + 1);
        } else {
            int xOffset = GunRefitScreen.getSlotTextureXOffset(gunItem, type);
            graphics.method_25293(GunRefitScreen.ICONS_TEXTURE, x + 2, y + 2, field_22758 - 4, field_22759 - 4, xOffset, 0, GunRefitScreen.ICON_UV_SIZE, GunRefitScreen.ICON_UV_SIZE, GunRefitScreen.getSlotsTextureWidth(), GunRefitScreen.ICON_UV_SIZE);
        }

        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public AttachmentType getType() {
        return type;
    }

    public class_1799 getAttachmentItem() {
        class_1799 gunItem = inventory.method_5438(gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return class_1799.field_8037;
        }
        return iGun.getAttachment(gunItem, type);
    }

    public boolean isAllow() {
        class_1799 gunItem = inventory.method_5438(gunItemIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return false;
        }
        return iGun.allowAttachmentType(gunItem, type);
    }
}
