package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClientMessageUnloadAttachment implements FabricPacket {
    public static final PacketType<ClientMessageUnloadAttachment> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "c2s_unload_attachment"), ClientMessageUnloadAttachment::new);

    private final int gunSlotIndex;
    private final AttachmentType attachmentType;

    public ClientMessageUnloadAttachment(class_2540 buf) {
        this(buf.readInt(), buf.method_10818(AttachmentType.class));
    }

    public ClientMessageUnloadAttachment(int gunSlotIndex, AttachmentType attachmentType) {
        this.gunSlotIndex = gunSlotIndex;
        this.attachmentType = attachmentType;
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(gunSlotIndex);
        buf.method_10817(attachmentType);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        class_1661 inventory = player.method_31548();
        class_1799 gunItem = inventory.method_5438(gunSlotIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun != null) {
            class_1799 attachmentItem = iGun.getAttachment(gunItem, attachmentType);
            if (!attachmentItem.method_7960() && inventory.method_7394(attachmentItem)) {
                iGun.unloadAttachment(gunItem, attachmentType);
                // 刷新配件数据
                AttachmentPropertyManager.postChangeEvent(player, gunItem);
                // 如果卸载的是扩容弹匣，吐出所有子弹
                if (attachmentType == AttachmentType.EXTENDED_MAG) {
                    iGun.dropAllAmmo(player, gunItem);
                }
                player.field_7498.method_7623();
                NetworkHandler.sendToClientPlayer(new ServerMessageRefreshRefitScreen(), player);
            }
        }
    }
}
