/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.client.other.IThirdPersonAnimation;
import com.tacz.guns.api.client.other.ThirdPersonManager;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.ClientIndexManager;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAmmoIndex;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.index.ClientBlockIndex;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public final class TimelessAPI {
    @Environment(value=EnvType.CLIENT)
    public static Optional<GunDisplayInstance> getGunDisplay(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IGun) {
            IGun iGun = (IGun)class_17922;
            class_2960 gunId = iGun.getGunId(stack);
            if (TimelessAPI.getCommonGunIndex(gunId).isEmpty()) {
                return Optional.empty();
            }
            class_2960 displayId = iGun.getGunDisplayId(stack);
            if (displayId.equals((Object)DefaultAssets.DEFAULT_GUN_DISPLAY_ID)) {
                return TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getDefaultDisplay);
            }
            return TimelessAPI.getGunDisplay(displayId, gunId);
        }
        return Optional.empty();
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<ClientGunIndex> getClientGunIndex(class_2960 gunId) {
        return Optional.ofNullable(ClientIndexManager.GUN_INDEX.get(gunId));
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<GunDisplayInstance> getGunDisplay(class_2960 displayId, class_2960 fallbackGunId) {
        if (displayId == null || displayId.equals((Object)DefaultAssets.DEFAULT_GUN_DISPLAY_ID)) {
            return TimelessAPI.getClientGunIndex(fallbackGunId).map(ClientGunIndex::getDefaultDisplay);
        }
        GunDisplayInstance instance = ClientIndexManager.GUN_DISPLAY.get(displayId);
        if (instance == null) {
            return TimelessAPI.getClientGunIndex(fallbackGunId).map(ClientGunIndex::getDefaultDisplay);
        }
        return Optional.of(instance);
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<ClientAttachmentIndex> getClientAttachmentIndex(class_2960 attachmentId) {
        return Optional.ofNullable(ClientIndexManager.ATTACHMENT_INDEX.get(attachmentId));
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<ClientAmmoIndex> getClientAmmoIndex(class_2960 ammoId) {
        return Optional.ofNullable(ClientIndexManager.AMMO_INDEX.get(ammoId));
    }

    @Environment(value=EnvType.CLIENT)
    public static Optional<ClientBlockIndex> getClientBlockIndex(class_2960 blockId) {
        return Optional.ofNullable(ClientIndexManager.BLOCK_INDEX.get(blockId));
    }

    @Environment(value=EnvType.CLIENT)
    public static Set<Map.Entry<class_2960, ClientGunIndex>> getAllClientGunIndex() {
        return ClientIndexManager.getAllGuns();
    }

    @Environment(value=EnvType.CLIENT)
    public static Set<Map.Entry<class_2960, ClientAmmoIndex>> getAllClientAmmoIndex() {
        return ClientIndexManager.getAllAmmo();
    }

    @Environment(value=EnvType.CLIENT)
    public static Set<Map.Entry<class_2960, ClientAttachmentIndex>> getAllClientAttachmentIndex() {
        return ClientIndexManager.getAllAttachments();
    }

    public static Optional<CommonBlockIndex> getCommonBlockIndex(class_2960 blockId) {
        return Optional.ofNullable(CommonAssetsManager.get().getBlockIndex(blockId));
    }

    public static Optional<CommonGunIndex> getCommonGunIndex(class_2960 gunId) {
        return Optional.ofNullable(CommonAssetsManager.get().getGunIndex(gunId));
    }

    public static Optional<CommonAttachmentIndex> getCommonAttachmentIndex(class_2960 attachmentId) {
        return Optional.ofNullable(CommonAssetsManager.get().getAttachmentIndex(attachmentId));
    }

    public static Optional<CommonAmmoIndex> getCommonAmmoIndex(class_2960 ammoId) {
        return Optional.ofNullable(CommonAssetsManager.get().getAmmoIndex(ammoId));
    }

    @Deprecated
    public static Optional<GunSmithTableRecipe> getRecipe(class_2960 recipeId) {
        return Optional.empty();
    }

    public static Set<Map.Entry<class_2960, CommonBlockIndex>> getAllCommonBlockIndex() {
        return CommonAssetsManager.get().getAllBlocks();
    }

    public static Set<Map.Entry<class_2960, CommonGunIndex>> getAllCommonGunIndex() {
        return CommonAssetsManager.get().getAllGuns();
    }

    public static Set<Map.Entry<class_2960, CommonAmmoIndex>> getAllCommonAmmoIndex() {
        return CommonAssetsManager.get().getAllAmmos();
    }

    public static Set<Map.Entry<class_2960, CommonAttachmentIndex>> getAllCommonAttachmentIndex() {
        return CommonAssetsManager.get().getAllAttachments();
    }

    @Deprecated
    public static Map<class_2960, GunSmithTableRecipe> getAllRecipes() {
        return Map.of();
    }

    public static void registerThirdPersonAnimation(String name, IThirdPersonAnimation animation) {
        ThirdPersonManager.register(name, animation);
    }
}

