/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.animation.statemachine;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.util.LuaNbtAccessor;
import com.tacz.guns.client.animation.statemachine.ItemAnimationStateContext;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.functional.ShellRender;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Vector3f;
import org.luaj.vm2.LuaTable;

public class GunAnimationStateContext
extends ItemAnimationStateContext {
    private class_1799 currentGunItem;
    private IGun iGun;
    private GunDisplayInstance display;
    private GunData gunData;
    private float walkDistAnchor = 0.0f;
    private LuaNbtAccessor nbtUtil;

    private <T> Optional<T> processGunData(BiFunction<IGun, GunDisplayInstance, T> processor) {
        if (this.iGun != null && this.display != null) {
            return Optional.ofNullable(processor.apply(this.iGun, this.display));
        }
        return Optional.empty();
    }

    private <T> Optional<T> processGunOperator(Function<IClientPlayerGunOperator, T> processor) {
        class_746 player = class_310.method_1551().field_1724;
        if (player != null) {
            return Optional.ofNullable(processor.apply(IClientPlayerGunOperator.fromLocalPlayer(player)));
        }
        return Optional.empty();
    }

    private <T> Optional<T> processRemoteGunOperator(Function<IGunOperator, T> processor) {
        return this.processCameraEntity(entity -> {
            if (entity instanceof class_1309) {
                IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)entity);
                return processor.apply(gunOperator);
            }
            return null;
        });
    }

    private <T> Optional<T> processCameraEntity(Function<class_1297, T> processor) {
        class_1297 entity = class_310.method_1551().field_1719;
        if (entity != null) {
            return Optional.ofNullable(processor.apply(entity));
        }
        return Optional.empty();
    }

    public boolean hasBulletInBarrel() {
        return this.processGunData((iGun, gunIndex) -> {
            Bolt boltType = this.gunData.getBolt();
            return boltType != Bolt.OPEN_BOLT && iGun.hasBulletInBarrel(this.currentGunItem);
        }).orElse(false);
    }

    public boolean isOverHeat() {
        return this.gunData.getHeatData() != null && this.iGun.isOverheatLocked(this.currentGunItem);
    }

    public float getHeatProgress() {
        return this.gunData.getHeatData() != null ? class_3532.method_15363((float)(this.iGun.getHeatAmount(this.currentGunItem) / this.gunData.getHeatData().getHeatMax()), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public long getShootInterval() {
        return this.processCameraEntity(entity -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                FireMode fireMode = this.iGun.getFireMode(this.currentGunItem);
                if (fireMode == FireMode.BURST) {
                    long coolDown = (long)(this.gunData.getBurstData().getMinInterval() * 1000.0);
                    return Math.max(coolDown, 0L);
                }
                long coolDown = this.gunData.getShootInterval(livingEntity, fireMode, this.currentGunItem);
                return Math.max(coolDown, 0L);
            }
            return 0L;
        }).orElse(0L);
    }

    public long getLastShootTimestamp() {
        return this.processGunOperator(operator -> operator.getDataHolder().clientLastShootTimestamp).orElse(-1L);
    }

    public long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    public void adjustClientShootInterval(long alpha) {
        this.processGunOperator(operator -> {
            long timestamp = operator.getDataHolder().clientShootTimestamp;
            operator.getDataHolder().clientShootTimestamp = timestamp + alpha;
            return null;
        });
    }

    public int getAmmoCount() {
        return this.processGunData((iGun, gunIndex) -> iGun.getCurrentAmmoCount(this.currentGunItem)).orElse(0);
    }

    public int getMaxAmmoCount() {
        return this.processGunData((iGun, gunIndex) -> AttachmentDataUtils.getAmmoCountWithAttachment(this.currentGunItem, this.gunData)).orElse(0);
    }

    public boolean hasAmmoToConsume() {
        if (!this.processRemoteGunOperator(IGunOperator::needCheckAmmo).orElse(true).booleanValue()) {
            return true;
        }
        if (this.iGun.useDummyAmmo(this.currentGunItem)) {
            return this.iGun.getDummyAmmoAmount(this.currentGunItem) > 0;
        }
        return this.processCameraEntity(entity -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                livingEntity.tacz$getItemHandler(null).map(cap -> {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        IAmmoBox iAmmoBox;
                        IAmmo iAmmo;
                        class_1799 checkAmmoStack = cap.getStackInSlot(i);
                        class_1792 patt0$temp = checkAmmoStack.method_7909();
                        if (patt0$temp instanceof IAmmo && (iAmmo = (IAmmo)patt0$temp).isAmmoOfGun(this.currentGunItem, checkAmmoStack)) {
                            return true;
                        }
                        class_1792 patt1$temp = checkAmmoStack.method_7909();
                        if (!(patt1$temp instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)patt1$temp).isAmmoBoxOfGun(this.currentGunItem, checkAmmoStack)) continue;
                        return true;
                    }
                    return false;
                }).orElse(false);
            }
            return false;
        }).orElse(false);
    }

    public int getMagExtentLevel() {
        return this.processGunData((iGun, gunIndex) -> AttachmentDataUtils.getMagExtendLevel(this.currentGunItem, this.gunData)).orElse(0);
    }

    public int getFireMode() {
        return this.processGunData((iGun, gunIndex) -> iGun.getFireMode(this.currentGunItem).ordinal()).orElse(0);
    }

    public float getAimingProgress() {
        return this.processGunOperator(operator -> Float.valueOf(operator.getClientAimingProgress(this.partialTicks))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public boolean isAiming() {
        return this.processGunOperator(IClientPlayerGunOperator::isAim).orElse(false);
    }

    public long getShootCoolDown() {
        return this.processGunOperator(IClientPlayerGunOperator::getClientShootCoolDown).orElse(0L);
    }

    public int getReloadStateType() {
        return this.processCameraEntity(entity -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                return IGunOperator.fromLivingEntity(livingEntity).getSynReloadState().getStateType().ordinal();
            }
            return ReloadState.StateType.NOT_RELOADING.ordinal();
        }).orElse(ReloadState.StateType.NOT_RELOADING.ordinal());
    }

    public boolean isInputUp() {
        return Optional.ofNullable(class_310.method_1551().field_1724).map(player -> player.field_3913.field_3910).orElse(false);
    }

    public boolean isInputDown() {
        return Optional.ofNullable(class_310.method_1551().field_1724).map(player -> player.field_3913.field_3909).orElse(false);
    }

    public boolean isInputLeft() {
        return Optional.ofNullable(class_310.method_1551().field_1724).map(player -> player.field_3913.field_3908).orElse(false);
    }

    public boolean isInputRight() {
        return Optional.ofNullable(class_310.method_1551().field_1724).map(player -> player.field_3913.field_3906).orElse(false);
    }

    public boolean isInputJumping() {
        return Optional.ofNullable(class_310.method_1551().field_1724).map(player -> player.field_3913.field_3904).orElse(false);
    }

    public boolean isCrawl() {
        return this.processGunOperator(IClientPlayerGunOperator::isCrawl).orElse(false);
    }

    public boolean isOnGround() {
        return this.processCameraEntity(class_1297::method_24828).orElse(false);
    }

    public boolean isCrouching() {
        return this.processCameraEntity(class_1297::method_18276).orElse(false);
    }

    public boolean shouldSlide() {
        return this.processCameraEntity(e -> e.method_18276() && this.gunData.canSlide()).orElse(false);
    }

    public void anchorWalkDist() {
        this.processCameraEntity(entity -> {
            this.walkDistAnchor = entity.field_5973 + (entity.field_5973 - entity.field_6039) * this.partialTicks;
            return null;
        });
    }

    public float getWalkDist() {
        return this.processCameraEntity(entity -> {
            float currentWalkDist = entity.field_5973 + (entity.field_5973 - entity.field_6039) * this.partialTicks;
            return Float.valueOf(currentWalkDist - this.walkDistAnchor);
        }).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void popShellFrom(int index) {
        BedrockGunModel gunModel;
        if (this.display.getShellEjection() != null && (gunModel = this.display.getGunModel()) != null) {
            ShellRender lodShell;
            Pair<BedrockGunModel, class_2960> lod;
            ShellRender shellRender = gunModel.getShellRender(index);
            Vector3f velocity = this.display.getShellEjection().getRandomVelocity();
            if (shellRender != null) {
                shellRender.addShell(velocity);
            }
            if ((lod = this.display.getLodModel()) != null && (lodShell = ((BedrockGunModel)lod.getLeft()).getShellRender(index)) != null) {
                lodShell.addShell(velocity);
            }
        }
    }

    public LuaTable getStateMachineParams() {
        LuaTable param = this.display.getStateMachineParam();
        return param == null ? new LuaTable() : param;
    }

    public LuaNbtAccessor getNbtAccessor() {
        return this.nbtUtil;
    }

    public String getAttachment(String type) {
        try {
            AttachmentType t = AttachmentType.valueOf(type);
            return this.iGun.getAttachmentId(this.currentGunItem, t).toString();
        }
        catch (IllegalArgumentException e) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID.toString();
        }
    }

    public void setCurrentGunItem(class_1799 currentGunItem) {
        this.currentGunItem = currentGunItem;
        this.iGun = IGun.getIGunOrNull(currentGunItem);
        if (this.iGun != null) {
            this.display = TimelessAPI.getGunDisplay(currentGunItem).orElse(null);
            this.gunData = TimelessAPI.getClientGunIndex(this.iGun.getGunId(currentGunItem)).map(ClientGunIndex::getGunData).orElse(null);
        }
        if (currentGunItem.method_7985()) {
            this.nbtUtil = new LuaNbtAccessor(currentGunItem.method_7969());
        }
    }
}

