/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.model.functional;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.resource.pojo.display.LaserConfig;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.util.LaserColorUtil;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_765;
import net.minecraft.class_811;

public class BeamRenderer {
    public static final class_2960 LASER_BEAM_TEXTURE = new class_2960("tacz", "textures/entity/beam.png");
    private static final LaserConfig DEFAULT_LASER_CONFIG = new LaserConfig();

    public static void renderLaserBeam(class_1799 stack, class_4587 poseStack, class_811 transformType, @Nonnull List<BedrockPart> path) {
        if (stack == null || !transformType.method_29998() && transformType != class_811.field_4320) {
            return;
        }
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_4588 builder = bufferSource.getBuffer(LaserBeamRenderState.getLaserBeam());
        poseStack.method_22903();
        for (int i = 0; i < path.size(); ++i) {
            path.get(i).translateAndRotateAndScale(poseStack);
        }
        LaserConfig laserConfig = BeamRenderer.getLaserConfig(stack);
        int color = LaserColorUtil.getLaserColor(stack, laserConfig);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        BeamRenderer.stringVertex(transformType.method_29998() ? (float)(-laserConfig.getLength()) : -laserConfig.getLengthThird(), transformType.method_29998() ? laserConfig.getWidth() : laserConfig.getWidthThird(), builder, poseStack.method_23760(), r, g, b, (Boolean)RenderConfig.ENABLE_LASER_FADE_OUT.get());
        poseStack.method_22909();
    }

    private static LaserConfig getLaserConfig(class_1799 stack) {
        if (stack == null) {
            return DEFAULT_LASER_CONFIG;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IAttachment) {
            IAttachment iAttachment = (IAttachment)class_17922;
            return TimelessAPI.getClientAttachmentIndex(iAttachment.getAttachmentId(stack)).map(ClientAttachmentIndex::getLaserConfig).orElse(DEFAULT_LASER_CONFIG);
        }
        if (stack.method_7909() instanceof IGun) {
            return TimelessAPI.getGunDisplay(stack).map(GunDisplayInstance::getLaserConfig).orElse(DEFAULT_LASER_CONFIG);
        }
        return DEFAULT_LASER_CONFIG;
    }

    private static void stringVertex(float z, float width, class_4588 pConsumer, class_4587.class_4665 pPose, int r, int g, int b, boolean fadeOut) {
        float halfWidth = width / 2.0f;
        int endAlpha = fadeOut ? 0 : 255;
        int light = class_765.method_23687((int)15, (int)15);
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, -halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 0.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, -halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 0.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 0.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 0.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 0.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, -halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, -halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 0.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, -halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, -halfWidth, 0.0f).method_1336(r, g, b, 255).method_22913(0.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), -halfWidth, -halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 1.0f).method_22916(light).method_1344();
        pConsumer.method_22918(pPose.method_23761(), halfWidth, -halfWidth, z).method_1336(r, g, b, endAlpha).method_22913(1.0f, 0.0f).method_22916(light).method_1344();
    }

    public static class LaserBeamRenderState
    extends class_4668 {
        protected static final class_4668.class_4685 LIGHTNING_ADDITIVE_TRANSPARENCY = new class_4668.class_4685("lightning_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        protected static final class_1921 LASER_BEAM = class_1921.method_24049((String)"laser_beam", (class_293)class_290.field_20888, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)true, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(class_4668.field_29441).method_23607(field_22241).method_23615(LIGHTNING_ADDITIVE_TRANSPARENCY).method_23610(field_25643).method_23608(field_21383).method_23616(field_21349).method_23603(field_21345).method_34577((class_4668.class_5939)new class_4668.class_4683(LASER_BEAM_TEXTURE, false, false)).method_23617(false));

        public LaserBeamRenderState(String pName, Runnable pSetupState, Runnable pClearState) {
            super(pName, pSetupState, pClearState);
        }

        public static class_1921 getLaserBeam() {
            return LASER_BEAM;
        }
    }
}

