package com.tacz.guns.client.event;

import cn.sh1rocu.tacz.api.event.RenderHandEvent;
import cn.sh1rocu.tacz.api.extension.IItem;
import com.tacz.guns.api.client.animation.statemachine.AnimationStateMachine;
import com.tacz.guns.api.client.other.KeepingItemRenderer;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.renderer.item.AnimateGeoItemRenderer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_811;

@Environment(EnvType.CLIENT)
public class FirstPersonRenderEvent {
    private static AnimationStateMachine<?> lastStateMachine = null;

    public static void onRenderHand(RenderHandEvent event) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (event.getHand() == class_1268.field_5810) {
            class_1799 stack = KeepingItemRenderer.getRenderer().getCurrentItem();
            if (stack.method_7909() instanceof IGun) {
                event.setCanceled(true);
            }
            return;
        }
        // 事件事件给的是被延长渲染修改过后的物品，不是玩家实际手持的
        class_1799 stack = event.getItemStack();

        // 获取 TransformType
        class_811 transformType;
        if (event.getHand() == class_1268.field_5808) {
            transformType = class_811.field_4322;
        } else {
            transformType = class_811.field_4321;
        }

        // 渲染相关内容整理到物品的IClientItemExtensions了，这个接口有待进一步抽象
        if (stack.method_7909() instanceof IItem item && item.getCustomRenderer() instanceof AnimateGeoItemRenderer<?, ?> renderer) {
            // 如果旧的状态机已经不再使用且未正常退出，使其静默退出
            AnimationStateMachine<?> machine = renderer.getStateMachine(stack);
            if (machine != lastStateMachine) {
                if (lastStateMachine != null && lastStateMachine.isInitialized()) {
                    lastStateMachine.exit();
                }
                lastStateMachine = machine;
            }
            // 物品处于后台时，阻止状态机初始化
            boolean flag = class_1799.method_7973(player.method_6047(), stack);
            if (flag && renderer.needReInit(stack)) {
                renderer.tryInit(stack, player, event.getPartialTick());
            }

            renderer.renderFirstPerson(player, stack, transformType, event.getPoseStack(), event.getMultiBufferSource(),
                    event.getPackedLight(), event.getPartialTick());
            event.setCanceled(true);
        }
    }
}
