package com.tacz.guns.client.resource.pojo.display.gun;

import com.google.common.collect.Maps;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.resource.pojo.display.IDisplay;
import com.tacz.guns.client.resource.pojo.display.LaserConfig;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_2960;
import java.util.EnumMap;
import java.util.Map;

public class GunDisplay implements IDisplay {
    @SerializedName("model_type")
    private String modelType = "default";
    @SerializedName("model")
    private class_2960 modelLocation;
    @SerializedName("texture")
    private class_2960 modelTexture;
    @SerializedName("iron_zoom")
    private float ironZoom = 1.2f;
    @SerializedName("zoom_model_fov")
    private float zoomModelFov = 70f;
    @Nullable
    @SerializedName("lod")
    private GunLod gunLod;
    @Nullable
    @SerializedName("hud")
    private class_2960 hudTextureLocation;
    @Nullable
    @SerializedName("hud_empty")
    private class_2960 hudEmptyTextureLocation;
    @Nullable
    @SerializedName("slot")
    private class_2960 slotTextureLocation;
    @NotNull
    @SerializedName("ammo_count_style")
    private AmmoCountStyle ammoCountStyle = AmmoCountStyle.NORMAL;
    @NotNull
    @SerializedName("damage_style")
    private DamageStyle damageStyle = DamageStyle.PER_PROJECTILE;
    @Nullable
    @SerializedName("third_person_animation")
    private String thirdPersonAnimation;
    @Nullable
    @SerializedName("animation")
    private class_2960 animationLocation;
    @Nullable
    @SerializedName("state_machine")
    private class_2960 stateMachineLocation;
    @Nullable
    @SerializedName("state_machine_param")
    private Map<String, Object> stateMachineParam = null;
    @Nullable
    @SerializedName("use_default_animation")
    // 弃用，优先使用 default_animation 指定默认动画
    private DefaultAnimationType defaultAnimationType;
    @Nullable
    @SerializedName("default_animation")
    private class_2960 defaultAnimation = null;
    @Nullable
    @SerializedName("player_animator_3rd")
    private class_2960 playerAnimator3rd;
    @Nullable
    @SerializedName("3rd_fixed_hand")
    private boolean playerAnimator3rdFixedHand = false;
    @Nullable
    @SerializedName("sounds")
    private Map<String, class_2960> sounds;
    @Nullable
    @SerializedName("transform")
    private GunTransform transform;
    @Nullable
    @SerializedName("shell")
    private ShellEjection shellEjection;
    @Nullable
    @SerializedName("ammo")
    private GunAmmo gunAmmo;
    @Nullable
    @SerializedName("muzzle_flash")
    private MuzzleFlash muzzleFlash;
    @SerializedName("offhand_show")
    private LayerGunShow offhandShow = new LayerGunShow();
    @Nullable
    @SerializedName("hotbar_show")
    private Map<String, LayerGunShow> hotbarShow = null;
    @SerializedName("text_show")
    private Map<String, TextShow> textShows = Maps.newHashMap();
    @SerializedName("show_crosshair")
    private boolean showCrosshair = false;
    @SerializedName("controllable")
    private EnumMap<FireMode, ControllableData> controllableData = Maps.newEnumMap(FireMode.class);
    @SerializedName("laser")
    private LaserConfig laserConfig;

    public String getModelType() {
        return modelType;
    }

    public class_2960 getModelLocation() {
        return modelLocation;
    }

    public class_2960 getModelTexture() {
        return modelTexture;
    }

    @Nullable
    public GunLod getGunLod() {
        return gunLod;
    }

    @Nullable
    public class_2960 getHudTextureLocation() {
        return hudTextureLocation;
    }

    @Nullable
    public class_2960 getHudEmptyTextureLocation() {
        return hudEmptyTextureLocation;
    }

    @Nullable
    public class_2960 getSlotTextureLocation() {
        return slotTextureLocation;
    }

    @Nullable
    public class_2960 getAnimationLocation() {
        return animationLocation;
    }

    @Nullable
    public class_2960 getStateMachineLocation() {
        return stateMachineLocation;
    }

    @Nullable
    public Map<String, Object> getStateMachineParam() {
        return stateMachineParam;
    }

    @Nullable
    public DefaultAnimationType getDefaultAnimationType() {
        return defaultAnimationType;
    }

    @Nullable
    public class_2960 getDefaultAnimation() {
        return defaultAnimation;
    }

    @Nullable
    public class_2960 getPlayerAnimator3rd() {
        return playerAnimator3rd;
    }

    @Nullable
    public String getThirdPersonAnimation() {
        return thirdPersonAnimation;
    }

    @Nullable
    public Map<String, class_2960> getSounds() {
        return sounds;
    }

    @Nullable
    public GunTransform getTransform() {
        return transform;
    }

    @Nullable
    public ShellEjection getShellEjection() {
        return shellEjection;
    }

    @Nullable
    public GunAmmo getGunAmmo() {
        return gunAmmo;
    }

    @Nullable
    public MuzzleFlash getMuzzleFlash() {
        return muzzleFlash;
    }

    public LayerGunShow getOffhandShow() {
        return offhandShow;
    }

    @Nullable
    public Map<String, LayerGunShow> getHotbarShow() {
        return hotbarShow;
    }

    public float getIronZoom() {
        return ironZoom;
    }

    public float getZoomModelFov() {
        return zoomModelFov;
    }

    public Map<String, TextShow> getTextShows() {
        return textShows;
    }

    public boolean isShowCrosshair() {
        return showCrosshair;
    }

    public EnumMap<FireMode, ControllableData> getControllableData() {
        return controllableData;
    }

    public @NotNull AmmoCountStyle getAmmoCountStyle() {
        return ammoCountStyle;
    }

    public @NotNull DamageStyle getDamageStyle() {
        return damageStyle;
    }

    @Nullable
    public LaserConfig getLaserConfig() {
        return laserConfig;
    }

    public boolean is3rdFixedHand() {
        return playerAnimator3rdFixedHand;
    }

    @Override
    public void init() {
        if (modelTexture != null) {
            modelTexture = converter.method_45112(modelTexture);
        }
        if (hudTextureLocation != null) {
            hudTextureLocation = converter.method_45112(hudTextureLocation);
        }
        if (hudEmptyTextureLocation != null) {
            hudEmptyTextureLocation = converter.method_45112(hudEmptyTextureLocation);
        }
        if (slotTextureLocation != null) {
            slotTextureLocation = converter.method_45112(slotTextureLocation);
        }
        if (gunLod != null && gunLod.modelTexture != null) {
            gunLod.modelTexture = converter.method_45112(gunLod.modelTexture);
        }
        if (muzzleFlash != null && muzzleFlash.texture != null) {
            muzzleFlash.texture = converter.method_45112(muzzleFlash.texture);
        }
    }
}
