package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

import java.util.HashMap;
import java.util.Map;

public class ClientMessageLaserColor implements FabricPacket {
    public static final PacketType<ClientMessageLaserColor> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "c2s_laser_color"), ClientMessageLaserColor::new);

    private final Map<AttachmentType, Integer> colorMap = new HashMap<>();
    private boolean applyGunColor = false;
    private int gunColor = 0;

    private int gunSlotIndex = -1;

    private ClientMessageLaserColor() {

    }

    public ClientMessageLaserColor(class_2540 buf) {
        this.colorMap.putAll(buf.method_34067(buf1 -> buf.method_10818(AttachmentType.class), class_2540::readInt));
        this.applyGunColor = buf.readBoolean();
        this.gunColor = buf.readInt();
        this.gunSlotIndex = buf.readInt();
    }

    public ClientMessageLaserColor(@NotNull class_1799 gun, int gunSlotIndex) {
        if (gun.method_7909() instanceof IGun iGun) {
            for (AttachmentType type : AttachmentType.values()) {
                class_1799 attachment = iGun.getAttachment(gun, type);
                if (attachment.method_7909() instanceof IAttachment iAttachment) {
                    if (iAttachment.hasCustomLaserColor(attachment)) {
                        colorMap.put(type, iAttachment.getLaserColor(attachment));
                    }
                }
            }
            if (iGun.hasCustomLaserColor(gun)) {
                this.gunColor = iGun.getLaserColor(gun);
                this.applyGunColor = true;
            }
            this.gunSlotIndex = gunSlotIndex;
        }
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_34063(colorMap, class_2540::method_10817, class_2540::writeInt);
        buf.writeBoolean(applyGunColor);
        buf.writeInt(gunColor);
        buf.writeInt(gunSlotIndex);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        class_1661 inventory = player.method_31548();
        class_1799 gunItem = inventory.method_5438(gunSlotIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun != null) {
            for (var entry : colorMap.entrySet()) {
                AttachmentType type = entry.getKey();
                int color = entry.getValue();
                class_1799 attachment = iGun.getAttachment(gunItem, type);
                if (attachment.method_7909() instanceof IAttachment iAttachment) {
                    iAttachment.setLaserColor(attachment, color);
                }
            }
            if (applyGunColor) {
                iGun.setLaserColor(gunItem, gunColor);
            }
        }
    }
}
