package com.tacz.guns.resource.manager;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.tacz.guns.GunMod;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.util.ResourceScanner;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.util.*;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;


public class AttachmentsTagManager extends class_4080<Map<class_2960, List<JsonElement>>> implements INetworkCacheReloadListener {
    private final Map<class_2960, Set<String>> tags = Maps.newHashMap();
    private final Map<class_2960, Set<String>> allow_attachments = Maps.newHashMap();

    private final Gson gson;
    private final Marker marker;

    private final class_7654 fileToIdConverter;
    protected Map<class_2960, String> networkCache;

    public AttachmentsTagManager() {
        this.gson = CommonAssetsManager.GSON;
        this.marker = MarkerFactory.getMarker("AllowTagManager");
        this.fileToIdConverter = class_7654.method_45114("tacz_tags/attachments");
    }

    @NotNull
    @Override
    protected Map<class_2960, List<JsonElement>> method_18789(class_3300 pResourceManager, class_3695 pProfiler) {
        return ResourceScanner.scanDirectoryAll(pResourceManager, this.fileToIdConverter, this.gson);
    }

    @Override
    protected void apply(Map<class_2960, List<JsonElement>> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        tags.clear();
        allow_attachments.clear();
        ImmutableMap.Builder<class_2960, String> builder = ImmutableMap.builder();

        for (Map.Entry<class_2960, List<JsonElement>> entry : pObject.entrySet()) {
            class_2960 id = entry.getKey();

            List<String> temp = new ArrayList<>();
            for (JsonElement element : entry.getValue()) {
                try {
                    List<String> data = parseJson(element);
                    if (data != null) {
                        if (data.stream().anyMatch(Objects::isNull)) {
                            throw new JsonParseException("Null value found in JSON data");
                        } else {
                            temp.addAll(data);
                        }
                    }
                } catch (JsonParseException e) {
                    GunMod.LOGGER.error(marker, "Failed to parse data file {}", id, e);
                }
            }

            if (id.method_12832().startsWith("allow_attachments/") && id.method_12832().length() > 18) {
                class_2960 gunId = id.method_45136(id.method_12832().substring(18));
                allow_attachments.computeIfAbsent(gunId, (v) -> Sets.newHashSet()).addAll(temp);
            } else {
                tags.computeIfAbsent(id, (v) -> Sets.newHashSet()).addAll(temp);
            }

            builder.put(entry.getKey(), gson.toJson(temp));
        }

        this.networkCache = builder.build();
    }

    private List<String> parseJson(JsonElement element) {
        return gson.fromJson(element, new TypeToken<>() {
        });
    }

    @Override
    public Map<class_2960, String> getNetworkCache() {
        return networkCache;
    }

    @Override
    public DataType getType() {
        return DataType.ATTACHMENT_TAGS;
    }

    public Set<String> getAttachmentTags(class_2960 registryName) {
        return tags.get(registryName);
    }

    public Set<String> getAllowAttachmentTags(class_2960 registryName) {
        return allow_attachments.get(registryName);
    }

    public static final class_2960 ID = new class_2960(GunMod.MOD_ID, "attachments_tag_manager");

    @Override
    public class_2960 getFabricId() {
        return null;
    }
}
