/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerCancelReload;
import com.tacz.guns.network.message.ClientMessagePlayerReloadGun;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_746;

public class LocalPlayerReload {
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerReload(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public void cancelReload() {
        class_1799 mainHandItem = this.player.method_6047();
        if (!(mainHandItem.method_7909() instanceof AbstractGunItem)) {
            return;
        }
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(display -> {
            IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)this.player);
            ReloadState reloadState = gunOperator.getSynReloadState();
            if (!reloadState.getStateType().isReloading()) {
                return;
            }
            ClientPlayNetworking.send((FabricPacket)new ClientMessagePlayerCancelReload());
            this.cancelReload((GunDisplayInstance)display);
        });
    }

    public void reload() {
        class_1799 mainHandItem = this.player.method_6047();
        class_1792 class_17922 = mainHandItem.method_7909();
        if (!(class_17922 instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)class_17922;
        class_2960 gunId = gunItem.getGunId(mainHandItem);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        if (gunData == null) {
            return;
        }
        TimelessAPI.getGunDisplay(mainHandItem).ifPresent(display -> {
            if (gunItem.useInventoryAmmo(mainHandItem)) {
                return;
            }
            if (this.data.clientStateLock) {
                return;
            }
            boolean canReload = gunItem.canReload((class_1309)this.player, mainHandItem);
            if (IGunOperator.fromLivingEntity((class_1309)this.player).needCheckAmmo() && !canReload) {
                return;
            }
            this.data.lockState(operator -> operator.getSynReloadState().getStateType().isReloading());
            GunReloadEvent gunReloadEvent = new GunReloadEvent((class_1309)this.player, this.player.method_6047(), LogicalSide.CLIENT);
            ((GunReloadEvent.Callback)GunReloadEvent.CALLBACK.invoker()).post(gunReloadEvent);
            if (gunReloadEvent.isCanceled()) {
                return;
            }
            ClientPlayNetworking.send((FabricPacket)new ClientMessagePlayerReloadGun());
            this.doReload(gunItem, (GunDisplayInstance)display, gunData, mainHandItem);
        });
    }

    private void doReload(IGun iGun, GunDisplayInstance display, GunData gunData, class_1799 mainHandItem) {
        LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
        if (animationStateMachine != null) {
            Bolt boltType = gunData.getBolt();
            boolean noAmmo = boltType == Bolt.OPEN_BOLT ? iGun.getCurrentAmmoCount(mainHandItem) <= 0 : !iGun.hasBulletInBarrel(mainHandItem);
            SoundPlayManager.stopPlayGunSound();
            SoundPlayManager.playReloadSound((class_1309)this.player, display, noAmmo);
            animationStateMachine.trigger("reload");
        }
    }

    private void cancelReload(GunDisplayInstance display) {
        LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
        if (animationStateMachine != null) {
            animationStateMachine.trigger("cancel_reload");
        }
    }
}

