/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.sync.core;

import cn.sh1rocu.tacz.util.forge.LazyOptional;
import com.tacz.guns.entity.sync.core.DataEntry;
import com.tacz.guns.entity.sync.core.DataHolder;
import com.tacz.guns.entity.sync.core.SyncedClassKey;
import com.tacz.guns.entity.sync.core.SyncedDataKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class DataHolderCapabilityProvider
implements Component {
    public static final ComponentKey<DataHolderCapabilityProvider> CAPABILITY = ComponentRegistry.getOrCreate((class_2960)new class_2960("tacz", "synced_entity_data"), DataHolderCapabilityProvider.class);
    private final DataHolder holder = new DataHolder();
    private final LazyOptional<DataHolder> optional = LazyOptional.of(() -> this.holder);

    public void invalidate() {
        this.optional.invalidate();
    }

    public Optional<DataHolder> getDataHolder() {
        return this.optional.resolve();
    }

    private class_2499 serializeNBT() {
        class_2499 list = new class_2499();
        this.holder.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                class_2487 keyTag = new class_2487();
                keyTag.method_10582("ClassKey", key.classKey().id().toString());
                keyTag.method_10582("DataKey", key.id().toString());
                keyTag.method_10566("Value", entry.writeValue());
                list.add((Object)keyTag);
            }
        });
        return list;
    }

    private void deserializeNBT(class_2499 listTag) {
        this.holder.dataMap.clear();
        listTag.forEach(entryTag -> {
            class_2487 keyTag = (class_2487)entryTag;
            class_2960 classKey = class_2960.method_12829((String)keyTag.method_10558("ClassKey"));
            class_2960 dataKey = class_2960.method_12829((String)keyTag.method_10558("DataKey"));
            class_2520 value = keyTag.method_10580("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = SyncedEntityData.instance().getKey(syncedClassKey, dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(syncedDataKey);
            entry.readValue(value);
            this.holder.dataMap.put(syncedDataKey, entry);
        });
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        this.deserializeNBT(tag.method_10554("DataHolder", 10));
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        class_2499 listTag = this.serializeNBT();
        tag.method_10566("DataHolder", (class_2520)listTag);
    }
}

