package cn.sh1rocu.tacz.api.event;

import com.google.common.collect.ImmutableList;
import com.tacz.guns.GunMod;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_5350;
import net.minecraft.class_5455;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

public class AddReloadListenerEvent extends BaseEvent {
    private final List<class_3302> listeners = new ArrayList<>();
    private final class_5350 serverResources;
    private final class_5455 registryAccess;

    public static Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> ((event) -> {
        for (Callback e : callbacks) {
            e.post(event);
        }
    }));

    public interface Callback {
        void post(AddReloadListenerEvent event);
    }

    public AddReloadListenerEvent(class_5350 serverResources, class_5455 registryAccess) {
        this.serverResources = serverResources;
        this.registryAccess = registryAccess;
    }

    public class_5350 getServerResources() {
        return serverResources;
    }

    public class_5455 getRegistryAccess() {
        return registryAccess;
    }

    public void addListener(class_3302 listener) {
        listeners.add(new WrappedStateAwareListener(listener));
    }

    public List<class_3302> getListeners() {
        return ImmutableList.copyOf(listeners);
    }

    private static class WrappedStateAwareListener implements class_3302 {
        private final class_3302 wrapped;

        private WrappedStateAwareListener(final class_3302 wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public CompletableFuture<Void> method_25931(final class_4045 stage, final class_3300 resourceManager, final class_3695 preparationsProfiler, final class_3695 reloadProfiler, final Executor backgroundExecutor, final Executor gameExecutor) {
            if (FabricLoader.getInstance().isModLoaded(GunMod.MOD_ID))
                return wrapped.method_25931(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            else
                return CompletableFuture.completedFuture(null);
        }
    }
}