package cn.sh1rocu.tacz.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;

public class PlayerEvent extends LivingEvent {
    private final class_1657 player;

    public static final Event<PlayerLoggedInCallback> LOGGED_IN = EventFactory.createArrayBacked(PlayerLoggedInCallback.class, callbacks -> event -> {
        for (PlayerLoggedInCallback callback : callbacks) callback.post(event);
    });

    public static final Event<PlayerLoggedOutCallback> LOGGED_OUT = EventFactory.createArrayBacked(PlayerLoggedOutCallback.class, callbacks -> event -> {
        for (PlayerLoggedOutCallback callback : callbacks) callback.post(event);
    });

    public interface PlayerLoggedInCallback {
        void post(PlayerLoggedInEvent event);
    }

    public interface PlayerLoggedOutCallback {
        void post(PlayerLoggedOutEvent event);
    }

    public PlayerEvent(class_1657 player) {
        super(player);
        this.player = player;
    }

    @Override
    public class_1657 getEntity() {
        return player;
    }

    public static class PlayerLoggedInEvent extends PlayerEvent {
        public PlayerLoggedInEvent(class_1657 player) {
            super(player);
        }
    }

    public static class PlayerLoggedOutEvent extends PlayerEvent {
        public PlayerLoggedOutEvent(class_1657 player) {
            super(player);
        }
    }

}