package com.tacz.guns.api.client.event;

import cn.sh1rocu.tacz.api.event.BaseEvent;
import com.tacz.guns.api.event.common.KubeJSGunEventPoster;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_4587;

/**
 * 在调用 ItemInHandRenderer#renderHandsWithItems 方法时触发该事件
 * 用于相机动画相关调用
 */
public class BeforeRenderHandEvent extends BaseEvent implements KubeJSGunEventPoster<BeforeRenderHandEvent> {
    private final class_4587 poseStack;

    public static Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(BeforeRenderHandEvent event);
    }

    public BeforeRenderHandEvent(class_4587 poseStack) {
        this.poseStack = poseStack;
        postClientEventToKubeJS(this);
    }

    public class_4587 getPoseStack() {
        return poseStack;
    }
}
