package com.tacz.guns.api.item;

import net.minecraft.class_1799;
import net.minecraft.class_2960;

/**
 * 子弹盒接口
 */
public interface IAmmoBox {
    /**
     * 获取子弹盒中的子弹 ID
     *
     * @param ammoBox 子弹盒
     * @return 子弹盒中的子弹 ID
     */
    class_2960 getAmmoId(class_1799 ammoBox);

    /**
     * 获取子弹盒中的子弹数量
     *
     * @param ammoBox 子弹盒
     * @return 子弹数量
     */
    int getAmmoCount(class_1799 ammoBox);

    /**
     * 设置子弹盒中子弹的 ID
     */
    void setAmmoId(class_1799 ammoBox, class_2960 ammoId);

    /**
     * 设置子弹盒中子弹数量
     */
    void setAmmoCount(class_1799 ammoBox, int count);

    /**
     * 子弹盒中的子弹是否属于这把枪
     *
     * @param gun     枪
     * @param ammoBox 子弹盒
     * @return 是否属于这把枪
     */
    boolean isAmmoBoxOfGun(class_1799 gun, class_1799 ammoBox);

    /**
     * 设置子弹盒的等级，
     *
     * @param ammoBox   子弹盒
     * @param ammoLevel 子弹盒等级
     * @return 修改后的子弹盒
     */
    class_1799 setAmmoLevel(class_1799 ammoBox, int ammoLevel);

    /**
     * 获取子弹盒的等级，
     *
     * @param ammoBox 子弹盒
     * @return 等级，从 0 开始
     */
    int getAmmoLevel(class_1799 ammoBox);

    /**
     * 是否是无限子弹盒
     *
     * @param ammoBox 子弹盒
     * @return 是否是无限子弹盒
     */
    boolean isCreative(class_1799 ammoBox);

    /**
     * 是否是全种类无限子弹盒
     *
     * @param ammoBox 子弹盒
     * @return 是否是全种类无限子弹盒
     */
    boolean isAllTypeCreative(class_1799 ammoBox);

    /**
     * 将该弹药箱设置为无限种类
     *
     * @param ammoBox   子弹盒
     * @param isAllType 是否是全弹种类型
     * @return 修改后的子弹盒
     */
    class_1799 setCreative(class_1799 ammoBox, boolean isAllType);
}
