package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import java.util.Objects;

public interface GunItemDataAccessor extends IGun {
    String GUN_ID_TAG = "GunId";
    String GUN_FIRE_MODE_TAG = "GunFireMode";
    String GUN_HAS_BULLET_IN_BARREL = "HasBulletInBarrel";
    String GUN_CURRENT_AMMO_COUNT_TAG = "GunCurrentAmmoCount";
    String GUN_ATTACHMENT_BASE = "Attachment";
    String GUN_EXP_TAG = "GunLevelExp";
    String GUN_DUMMY_AMMO = "DummyAmmo";
    String GUN_MAX_DUMMY_AMMO = "MaxDummyAmmo";
    String GUN_ATTACHMENT_LOCK = "AttachmentLock";
    String GUN_DISPLAY_ID_TAG = "GunDisplayId";
    String LASER_COLOR_TAG = "LaserColor";
    String GUN_OVERHEAT_TAG = "HeatAmount";
    String GUN_OVERHEAT_LOCK_TAG = "OverHeated";

    @Override
    default boolean useDummyAmmo(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        return nbt.method_10573(GUN_DUMMY_AMMO, class_2520.field_33253);
    }

    @Override
    default int getDummyAmmoAmount(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        return Math.max(0, nbt.method_10550(GUN_DUMMY_AMMO));
    }

    @Override
    default void setDummyAmmoAmount(class_1799 gun, int amount) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10569(GUN_DUMMY_AMMO, Math.max(amount, 0));
        }));
    }

    @Override
    default void addDummyAmmoAmount(class_1799 gun, int amount) {
        if (!useDummyAmmo(gun)) {
            return;
        }
        int maxDummyAmmo = Integer.MAX_VALUE;
        if (hasMaxDummyAmmo(gun)) {
            maxDummyAmmo = getMaxDummyAmmoAmount(gun);
        }
        final int dummyAmmo = Math.min(getDummyAmmoAmount(gun) + amount, maxDummyAmmo);
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10569(GUN_DUMMY_AMMO, Math.max(dummyAmmo, 0));
        }));
    }

    @Override
    default boolean hasMaxDummyAmmo(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        return nbt.method_10573(GUN_MAX_DUMMY_AMMO, class_2520.field_33253);
    }

    @Override
    default int getMaxDummyAmmoAmount(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        return Math.max(0, nbt.method_10550(GUN_MAX_DUMMY_AMMO));
    }

    @Override
    default void setMaxDummyAmmoAmount(class_1799 gun, int amount) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10569(GUN_MAX_DUMMY_AMMO, Math.max(amount, 0));
        }));
    }

    @Override
    default boolean hasAttachmentLock(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_ATTACHMENT_LOCK, class_2520.field_33251)) {
            return nbt.method_10577(GUN_ATTACHMENT_LOCK);
        }
        return false;
    }

    @Override
    default void setAttachmentLock(class_1799 gun, boolean lock) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10556(GUN_ATTACHMENT_LOCK, lock);
        }));
    }

    @Override
    @Nonnull
    default class_2960 getGunId(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_ID_TAG, class_2520.field_33258)) {
            class_2960 gunId = class_2960.method_12829(nbt.method_10558(GUN_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_GUN_ID);
        }
        return DefaultAssets.EMPTY_GUN_ID;
    }

    @Override
    default void setGunId(class_1799 gun, @Nullable class_2960 gunId) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            if (gunId != null) {
                tag.method_10582(GUN_ID_TAG, gunId.toString());
            }
        }));
    }

    @Override
    @NotNull
    default class_2960 getGunDisplayId(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_DISPLAY_ID_TAG, class_2520.field_33258)) {
            class_2960 gunDisplayId = class_2960.method_12829(nbt.method_10558(GUN_DISPLAY_ID_TAG));
            return Objects.requireNonNullElse(gunDisplayId, DefaultAssets.DEFAULT_GUN_DISPLAY_ID);
        }
        return DefaultAssets.DEFAULT_GUN_DISPLAY_ID;
    }

    @Override
    default void setGunDisplayId(class_1799 gun, class_2960 displayId) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            if (displayId != null) {
                tag.method_10582(GUN_DISPLAY_ID_TAG, displayId.toString());
            }
        }));
    }

    @Override
    default int getLevel(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_EXP_TAG, class_2520.field_33253)) {
            return getLevel(nbt.method_10550(GUN_EXP_TAG));
        }
        return 0;
    }

    @Override
    default int getExp(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_EXP_TAG, class_2520.field_33253)) {
            return nbt.method_10550(GUN_EXP_TAG);
        }
        return 0;
    }

    @Override
    default int getExpToNextLevel(class_1799 gun) {
        int exp = getExp(gun);
        int level = getLevel(exp);
        if (level >= getMaxLevel()) {
            return 0;
        }
        int nextLevelExp = getExp(level + 1);
        return nextLevelExp - exp;
    }

    @Override
    default int getExpCurrentLevel(class_1799 gun) {
        int exp = getExp(gun);
        int level = getLevel(exp);
        if (level <= 0) {
            return exp;
        } else {
            return exp - getExp(level - 1);
        }
    }

    @Override
    default FireMode getFireMode(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_FIRE_MODE_TAG, class_2520.field_33258)) {
            return FireMode.valueOf(nbt.method_10558(GUN_FIRE_MODE_TAG));
        }
        return FireMode.UNKNOWN;
    }

    @Override
    default void setFireMode(class_1799 gun, @Nullable FireMode fireMode) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            if (fireMode != null) {
                tag.method_10582(GUN_FIRE_MODE_TAG, fireMode.name());
                return;
            }
            tag.method_10582(GUN_FIRE_MODE_TAG, FireMode.UNKNOWN.name());
        }));
    }

    @Override
    default int getCurrentAmmoCount(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_CURRENT_AMMO_COUNT_TAG, class_2520.field_33253)) {
            return nbt.method_10550(GUN_CURRENT_AMMO_COUNT_TAG);
        }
        return 0;
    }

    @Override
    default void setCurrentAmmoCount(class_1799 gun, int ammoCount) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10569(GUN_CURRENT_AMMO_COUNT_TAG, Math.max(ammoCount, 0));
        }));
    }

    @Override
    default void reduceCurrentAmmoCount(class_1799 gun) {
        // 只在不使用背包直读的情况下减少 AmmoCount
        if (!useInventoryAmmo(gun)) {
            setCurrentAmmoCount(gun, getCurrentAmmoCount(gun) - 1);
        }
    }

    @Override
    @Nullable
    default class_2487 getAttachmentTag(class_1799 gun, AttachmentType type) {
        if (!allowAttachmentType(gun, type)) {
            return null;
        }
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        String key = GUN_ATTACHMENT_BASE + type.name();
        if (!nbt.method_10573(key, class_2520.field_33260)) return null;
        class_2487 stack = nbt.method_10562(key);
        if (!stack.method_10573("components", class_2520.field_33260)) return null;
        class_2487 components = stack.method_10562("components");
        if (!components.method_10545(class_9334.field_49628.toString())) return null;
        return components.method_10562(class_9334.field_49628.toString());
    }

    @Override
    default void setAttachmentTag(class_1799 gun, AttachmentType type, class_2487 attachmentTag) {
        if (!allowAttachmentType(gun, type)) {
            return;
        }
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            String key = GUN_ATTACHMENT_BASE + type.name();
            if (!tag.method_10573(key, class_2520.field_33260)) return;
            class_2487 stack = tag.method_10562(key);
            if (!stack.method_10573("components", class_2520.field_33260)) return;
            class_2487 components = stack.method_10562("components");
            if (!components.method_10545(class_9334.field_49628.toString())) return;
            components.method_10566(class_9334.field_49628.toString(), attachmentTag);
        }));
    }

    @Override
    @NotNull
    default class_1799 getBuiltinAttachment(class_1799 gun, AttachmentType type) {
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun == null) {
            return class_1799.field_8037;
        }
        CommonGunIndex index = TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).orElse(null);
        if (index != null) {
            var builtin = index.getGunData().getBuiltInAttachments();
            if (builtin.containsKey(type)) {
                return AttachmentItemBuilder.create().setId(builtin.get(type)).build();
            }
        }
        return class_1799.field_8037;
    }

    @Override
    @Nonnull
    default class_1799 getAttachment(class_7225.class_7874 provider, class_1799 gun, AttachmentType type) {
        if (!allowAttachmentType(gun, type)) {
            return class_1799.field_8037;
        }
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        String key = GUN_ATTACHMENT_BASE + type.name();
        if (nbt.method_10573(key, class_2520.field_33260)) {
            return class_1799.field_24671.parse(provider.method_57093(class_2509.field_11560), nbt.method_10562(key)).result().orElse(class_1799.field_8037);
        }
        return class_1799.field_8037;
    }

    @Override
    @NotNull
    default class_2960 getBuiltInAttachmentId(class_1799 gun, AttachmentType type) {
        IGun iGun = IGun.getIGunOrNull(gun);
        if (iGun == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        CommonGunIndex index = TimelessAPI.getCommonGunIndex(iGun.getGunId(gun)).orElse(null);
        if (index != null) {
            var builtin = index.getGunData().getBuiltInAttachments();
            if (builtin.containsKey(type)) {
                return builtin.get(type);
            }
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    @Nonnull
    default class_2960 getAttachmentId(class_1799 gun, AttachmentType type) {
        class_2487 attachmentTag = this.getAttachmentTag(gun, type);
        if (attachmentTag != null) {
            return AttachmentItemDataAccessor.getAttachmentIdFromTag(attachmentTag);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    @Override
    default void installAttachment(class_7225.class_7874 provider, @Nonnull class_1799 gun, @Nonnull class_1799 attachment) {
        if (!allowAttachment(gun, attachment)) {
            return;
        }
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull(attachment);
        if (iAttachment == null) {
            return;
        }
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            String key = GUN_ATTACHMENT_BASE + iAttachment.getType(attachment).name();
            class_2520 attachmentTag;
            if (provider == null) {
                attachmentTag = class_1799.field_24671.encodeStart(class_2509.field_11560, attachment).getOrThrow();
            } else {
                attachmentTag = attachment.method_57375(provider);
            }
            tag.method_10566(key, attachmentTag);
        }));
    }

    @Override
    default void unloadAttachment(class_7225.class_7874 provider, @Nonnull class_1799 gun, AttachmentType type) {
        if (!allowAttachmentType(gun, type)) {
            return;
        }
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            String key = GUN_ATTACHMENT_BASE + type.name();
            tag.method_10566(key, class_1799.field_8037.method_57375(provider));
        }));
    }

    @Override
    default float getAimingZoom(class_1799 gunItem) {
        float zoom = 1;
        class_2960 scopeId = this.getAttachmentId(gunItem, AttachmentType.SCOPE);
        boolean builtin = false;
        if (scopeId.equals(DefaultAssets.EMPTY_ATTACHMENT_ID)) {
            scopeId = getBuiltInAttachmentId(gunItem, AttachmentType.SCOPE);
            builtin = true;
        }
        if (!DefaultAssets.isEmptyAttachmentId(scopeId)) {
            class_2487 attachmentTag = this.getAttachmentTag(gunItem, AttachmentType.SCOPE);
            int zoomNumber = builtin ? 0 : AttachmentItemDataAccessor.getZoomNumberFromTag(attachmentTag);
            float[] zooms = TimelessAPI.getClientAttachmentIndex(scopeId).map(ClientAttachmentIndex::getZoom).orElse(null);
            if (zooms != null) {
                zoom = zooms[zoomNumber % zooms.length];
            }
        } else {
            zoom = TimelessAPI.getGunDisplay(gunItem).map(GunDisplayInstance::getIronZoom).orElse(1f);
        }
        return zoom;
    }

    @Override
    default boolean hasBulletInBarrel(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (nbt.method_10573(GUN_HAS_BULLET_IN_BARREL, class_2520.field_33251)) {
            return nbt.method_10577(GUN_HAS_BULLET_IN_BARREL);
        }
        return false;
    }

    @Override
    default void setBulletInBarrel(class_1799 gun, boolean bulletInBarrel) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10556(GUN_HAS_BULLET_IN_BARREL, bulletInBarrel);
        }));
    }

    @Override
    default boolean hasCustomLaserColor(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        return nbt.method_10573(LASER_COLOR_TAG, class_2520.field_33253);
    }

    @Override
    default int getLaserColor(class_1799 gun) {
        class_2487 nbt = gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461();
        if (!hasCustomLaserColor(gun)) {
            return 0xFF0000;
        }
        return nbt.method_10550(LASER_COLOR_TAG);
    }

    @Override
    default void setLaserColor(class_1799 gun, int color) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10569(LASER_COLOR_TAG, color);
        }));
    }

    /**
     * Heat Data
     */
    @Override
    default boolean hasHeatData(class_1799 gun) {
        return gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461().method_10573(GUN_OVERHEAT_TAG, class_2520.field_33255);
    }

    @Override
    default boolean isOverheatLocked(class_1799 gun) {
        return gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461().method_10577(GUN_OVERHEAT_LOCK_TAG);
    }

    @Override
    default void setOverheatLocked(class_1799 gun, boolean locked) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10556(GUN_OVERHEAT_LOCK_TAG, locked);
        }));
    }

    @Override
    default float getHeatAmount(class_1799 gun) {
        if (hasHeatData(gun))
            return gun.method_57825(class_9334.field_49628, class_9279.field_49302).method_57461().method_10583(GUN_OVERHEAT_TAG);
        return 0f;
    }

    @Override
    default void setHeatAmount(class_1799 gun, float amount) {
        gun.method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
            tag.method_10548(GUN_OVERHEAT_TAG, amount >= 0 ? amount : 0f);
        }));
    }

    @Override
    default float lerpRPM(class_1799 gun) {
        return TimelessAPI.getCommonGunIndex(getGunId(gun))
                .map(index -> index.getGunData().getHeatData())
                .map(heatData -> {
                    float heatPercentage = (getHeatAmount(gun) / heatData.getHeatMax());
                    return class_3532.method_16439(heatPercentage, heatData.getMinRpmMod(), heatData.getMaxRpmMod());
                }).orElse(1f);
    }

    @Override
    default float lerpInaccuracy(class_1799 gun) {
        return TimelessAPI.getCommonGunIndex(getGunId(gun))
                .map(index -> index.getGunData().getHeatData())
                .map(heatData -> {
                    float heatPercentage = (getHeatAmount(gun) / heatData.getHeatMax());
                    return class_3532.method_16439(heatPercentage, heatData.getMinInaccuracy(), heatData.getMaxInaccuracy());
                }).orElse(1f);
    }
}