package com.tacz.guns.command.sub;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tacz.guns.config.PreLoadConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class OverwriteCommand {
    private static final String OVERWRITE_NAME = "overwrite";
    private static final String ENABLE = "enable";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> reload = class_2170.method_9247(OVERWRITE_NAME);
        RequiredArgumentBuilder<class_2168, Boolean> enable = class_2170.method_9244(ENABLE, BoolArgumentType.bool());
        reload.then(enable.executes(OverwriteCommand::setOverwrite));
        return reload;
    }

    private static int setOverwrite(CommandContext<class_2168> context) {
        boolean enable = BoolArgumentType.getBool(context, ENABLE);
        PreLoadConfig.override.set(!enable);
        PreLoadConfig.override.save();
        if (context.getSource().method_9228() instanceof class_3222 serverPlayer) {
            if (PreLoadConfig.override.get()) {
                serverPlayer.method_43496(class_2561.method_43471("commands.tacz.reload.overwrite_off"));
            } else {
                serverPlayer.method_43496(class_2561.method_43471("commands.tacz.reload.overwrite_on"));
            }
        }
        return Command.SINGLE_SUCCESS;
    }
}
