package com.tacz.guns.entity.sync.core;

import cn.sh1rocu.tacz.util.forge.LazyOptional;
import com.tacz.guns.GunMod;
import org.jetbrains.annotations.NotNull;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;

import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class DataHolderCapabilityProvider implements Component {
    public static final ComponentKey<DataHolderCapabilityProvider> CAPABILITY = ComponentRegistry.getOrCreate(class_2960.method_60655(GunMod.MOD_ID, "synced_entity_data"), DataHolderCapabilityProvider.class);
    private final DataHolder holder = new DataHolder();
    private final LazyOptional<DataHolder> optional = LazyOptional.of(() -> this.holder);

    public void invalidate() {
        this.optional.invalidate();
    }

    public Optional<DataHolder> getDataHolder() {
        return optional.resolve();
    }

    private class_2499 serializeNBT(class_7225.@NotNull class_7874 provider) {
        class_2499 list = new class_2499();
        this.holder.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                class_2487 keyTag = new class_2487();
                keyTag.method_10582("ClassKey", key.classKey().id().toString());
                keyTag.method_10582("DataKey", key.id().toString());
                keyTag.method_10566("Value", entry.writeValue(provider));
                list.add(keyTag);
            }
        });
        return list;
    }

    private void deserializeNBT(class_7225.@NotNull class_7874 provider, class_2499 listTag) {
        this.holder.dataMap.clear();
        listTag.forEach(entryTag -> {
            class_2487 keyTag = (class_2487) entryTag;
            class_2960 classKey = class_2960.method_12829(keyTag.method_10558("ClassKey"));
            class_2960 dataKey = class_2960.method_12829(keyTag.method_10558("DataKey"));
            class_2520 value = keyTag.method_10580("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = SyncedEntityData.instance().getKey(syncedClassKey, dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry<?, ?> entry = new DataEntry<>(syncedDataKey);
            entry.readValue(provider, value);
            this.holder.dataMap.put(syncedDataKey, entry);
        });
    }

    @Override
    public void readFromNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 provider) {
        deserializeNBT(provider, tag.method_10554("DataHolder", class_2520.field_33260));
    }

    @Override
    public void writeToNbt(@NotNull class_2487 tag, class_7225.@NotNull class_7874 provider) {
        class_2499 listTag = serializeNBT(provider);
        tag.method_10566("DataHolder", listTag);
    }
}
