package com.tacz.guns.resource.pojo.data.recipe;

import com.google.gson.annotations.SerializedName;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import java.util.List;
import net.minecraft.class_2371;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class TableRecipe {
    public static final MapCodec<TableRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            GunSmithTableIngredient.CODEC.listOf().fieldOf("materials").forGetter(TableRecipe::getMaterials),
            GunSmithTableResult.CODEC.fieldOf("result").forGetter(TableRecipe::getResult)
    ).apply(instance, TableRecipe::new));
    public static final class_9139<class_9129, TableRecipe> STREAM_CODEC = class_9139.method_56435(
            GunSmithTableIngredient.STREAM_CODEC.method_56433(class_9135.method_56374(class_2371::method_37434)), TableRecipe::getMaterials,
            GunSmithTableResult.STREAM_CODEC, TableRecipe::getResult,
            TableRecipe::new
    );

    public TableRecipe() {

    }

    public TableRecipe(List<GunSmithTableIngredient> materials, GunSmithTableResult result) {
        this.materials = materials;
        this.result = result;
    }

    @SerializedName("materials")
    private List<GunSmithTableIngredient> materials;

    @SerializedName("result")
    private GunSmithTableResult result;

    public List<GunSmithTableIngredient> getMaterials() {
        return materials;
    }

    public GunSmithTableResult getResult() {
        return result;
    }
}