package com.tacz.guns.util.block;

import cn.sh1rocu.tacz.mixin.accessor.ExplosionAccessor;
import com.google.common.collect.Sets;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.util.HitboxHelper;
import javax.annotation.Nullable;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ProjectileExplosion extends class_1927 {
    private static final class_5362 DEFAULT_CONTEXT = new class_5362();
    private final class_1937 level;
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final float radius;
    private final boolean knockback;
    private final class_1297 owner;
    private final class_1297 exploder;
    private final class_5362 damageCalculator;

    public ProjectileExplosion(class_1937 level, class_1297 owner, class_1297 exploder, @Nullable class_1282 source, @Nullable class_5362 damageCalculator, double x, double y, double z, float power, float radius, boolean knockback, class_1927.class_4179 mode) {
        super(level, exploder, source, damageCalculator, x, y, z, radius, AmmoConfig.EXPLOSIVE_AMMO_FIRE.get(), mode, class_2398.field_11236, class_2398.field_11236, class_3417.field_15152);
        this.field_9187 = level;
        this.field_9195 = x;
        this.field_9192 = y;
        this.field_9189 = z;
        this.power = power;
        this.field_9190 = radius;
        this.owner = owner;
        this.exploder = exploder;
        this.field_25400 = damageCalculator == null ? DEFAULT_CONTEXT : damageCalculator;
        this.knockback = knockback;
    }

    @Override
    public void method_8348() {
        this.field_9187.method_33596(this.exploder, class_5712.field_28178, class_2338.method_49637(this.field_9195, this.field_9192, this.field_9189));
        Set<class_2338> set = Sets.newHashSet();
        int i = 16;

        for (int x = 0; x < i; ++x) {
            for (int y = 0; y < i; ++y) {
                for (int z = 0; z < i; ++z) {
                    if (x == 0 || x == i - 1 || y == 0 || y == i - 1 || z == 0 || z == i - 1) {
                        double d0 = ((float) x / (i - 1) * 2.0F - 1.0F);
                        double d1 = ((float) y / (i - 1) * 2.0F - 1.0F);
                        double d2 = ((float) z / (i - 1) * 2.0F - 1.0F);
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        float f = this.field_9190 * (0.7F + this.field_9187.field_9229.method_43057() * 0.6F);
                        double blockX = this.field_9195;
                        double blockY = this.field_9192;
                        double blockZ = this.field_9189;

                        for (float f1 = 0.3F; f > 0.0F; f -= 0.22500001F) {
                            class_2338 pos = class_2338.method_49637(blockX, blockY, blockZ);
                            class_2680 blockState = this.field_9187.method_8320(pos);
                            class_3610 fluidState = this.field_9187.method_8316(pos);
                            if (!this.field_9187.method_24794(pos)) {
                                break;
                            }

                            Optional<Float> optional = this.field_25400.method_29555(this, this.field_9187, pos, blockState, fluidState);
                            if (optional.isPresent()) {
                                f -= (optional.get() + f1) * f1;
                            }

                            if (f > 0.0F && this.field_25400.method_29554(this, this.field_9187, pos, blockState, f)) {
                                set.add(pos);
                            }

                            blockX += d0 * (double) f1;
                            blockY += d1 * (double) f1;
                            blockZ += d2 * (double) f1;
                        }
                    }
                }
            }
        }

        this.method_8346().addAll(set);
        float radius = this.field_9190;
        int minX = class_3532.method_15357(this.field_9195 - (double) radius - 1.0D);
        int maxX = class_3532.method_15357(this.field_9195 + (double) radius + 1.0D);
        int minY = class_3532.method_15357(this.field_9192 - (double) radius - 1.0D);
        int maxY = class_3532.method_15357(this.field_9192 + (double) radius + 1.0D);
        int minZ = class_3532.method_15357(this.field_9189 - (double) radius - 1.0D);
        int maxZ = class_3532.method_15357(this.field_9189 + (double) radius + 1.0D);
        radius *= 2;
        List<class_1297> entities = this.field_9187.method_8335(this.exploder, new class_238(minX, minY, minZ, maxX, maxY, maxZ));
        // net.minecraftforge.event.ForgeEventFactory.onExplosionDetonate(this.level, this, entities, radius);
        class_243 explosionPos = new class_243(this.field_9195, this.field_9192, this.field_9189);

        for (class_1297 entity : entities) {
            if (entity.method_5659(this)) {
                continue;
            }

            class_238 boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.owner);
            class_3965 result;
            double strength;
            double deltaX;
            double deltaY;
            double deltaZ;
            double minDistance = radius;

            class_243[] d = new class_243[15];

            if (!(entity instanceof class_1309)) {
                strength = Math.sqrt(entity.method_5707(explosionPos)) * 2 / radius;
                deltaX = entity.method_23317() - this.field_9195;
                deltaY = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.field_9192;
                deltaZ = entity.method_23321() - this.field_9189;
            } else {
                deltaX = (boundingBox.field_1320 + boundingBox.field_1323) / 2;
                deltaY = (boundingBox.field_1325 + boundingBox.field_1322) / 2;
                deltaZ = (boundingBox.field_1324 + boundingBox.field_1321) / 2;
                d[0] = new class_243(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1321);
                d[1] = new class_243(boundingBox.field_1323, boundingBox.field_1322, boundingBox.field_1324);
                d[2] = new class_243(boundingBox.field_1323, boundingBox.field_1325, boundingBox.field_1321);
                d[3] = new class_243(boundingBox.field_1320, boundingBox.field_1322, boundingBox.field_1321);
                d[4] = new class_243(boundingBox.field_1323, boundingBox.field_1325, boundingBox.field_1324);
                d[5] = new class_243(boundingBox.field_1320, boundingBox.field_1322, boundingBox.field_1324);
                d[6] = new class_243(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1321);
                d[7] = new class_243(boundingBox.field_1320, boundingBox.field_1325, boundingBox.field_1324);
                d[8] = new class_243(boundingBox.field_1323, deltaY, deltaZ);
                d[9] = new class_243(boundingBox.field_1320, deltaY, deltaZ);
                d[10] = new class_243(deltaX, boundingBox.field_1322, deltaZ);
                d[11] = new class_243(deltaX, boundingBox.field_1325, deltaZ);
                d[12] = new class_243(deltaX, deltaY, boundingBox.field_1321);
                d[13] = new class_243(deltaX, deltaY, boundingBox.field_1324);
                d[14] = new class_243(deltaX, deltaY, deltaZ);
                for (int s = 0; s < 15; s++) {
                    result = BlockRayTrace.rayTraceBlocks(this.field_9187, new class_3959(explosionPos, d[s], class_3959.class_3960.field_17558, class_3959.class_242.field_1348, class_3726.method_16194()));
                    minDistance = (result.method_17783() != class_3965.Type.field_1332) ? Math.min(minDistance, explosionPos.method_1022(d[s])) : minDistance;
                }
                strength = minDistance * 2 / radius;
                deltaX -= this.field_9195;
                deltaY -= this.field_9192;
                deltaZ -= this.field_9189;
            }

            if (strength > 1.0D) {
                continue;
            }

            double distanceToExplosion = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);

            if (distanceToExplosion != 0.0D) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            }

            double damage = 1.0D - strength;
            entity.method_5643(((ExplosionAccessor) this).tacz$getDamageSource(), (float) damage * this.power);

            if (entity instanceof class_1309 livingEntity) {
                damage *= (1.0F - livingEntity.method_45325(class_5134.field_51580));
            }

            float multiplier = this.power * radius / 500;
            // 启用击退效果
            if (AmmoConfig.EXPLOSIVE_AMMO_KNOCK_BACK.get() && this.knockback) {
                entity.method_18799(entity.method_18798().method_1031(deltaX * damage * multiplier, deltaY * damage * multiplier, deltaZ * damage * multiplier));
                if (entity instanceof class_1657 player) {
                    if (!player.method_7325() && (!player.method_7337() || !player.method_31549().field_7479)) {
                        this.method_8351().put(player, new class_243(deltaX * damage * multiplier, deltaY * damage * multiplier, deltaZ * damage * multiplier));
                    }
                }
            }
        }
    }
}
